/*
 * Decompiled with CFR 0.152.
 */
package com.ivegotwood;

import com.google.inject.Provides;
import com.ivegotwood.IveGotWoodConfig;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="I've Got Wood", description="Displays messages overhead while doing certain skilling activies.", tags={"funny", "skilling", "text", "woodcutting", "fishing", "mining", "construction"})
public class IveGotWoodPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(IveGotWoodPlugin.class);
    private static final InventoryID INVENTORY = InventoryID.INVENTORY;
    private HashMap<Skill, Integer> oldXP = new HashMap();
    private HashMap<Skill, Integer> newXP = new HashMap();
    private boolean initialized;
    private boolean isXPUploaded;
    @Inject
    private Client client;
    @Inject
    private IveGotWoodConfig config;

    private void updateSkill(Skills skill, boolean enabled, String message) {
        skill.setEnabled(enabled);
        skill.setMessage(message);
    }

    private void updateSkills() {
        this.updateSkill(Skills.WOODCUTTING, this.config.enableWoodcuttingMessage(), this.config.woodcuttingMessage());
        this.updateSkill(Skills.FISHING, this.config.enableFishingMessage(), this.config.fishingMessage());
        this.updateSkill(Skills.MINING, this.config.enableMiningMessage(), this.config.miningMessage());
        this.updateSkill(Skills.CONSTRUCTION, this.config.enableConstructionMessage(), this.config.constructionMessage());
    }

    protected void startUp() throws Exception {
        log.info("Ive got wood started!");
        this.initialized = false;
        this.updateSkills();
    }

    protected void shutDown() throws Exception {
        log.info("Ive got wood stopped!");
        this.oldXP.clear();
        this.newXP.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        GameState state = event.getGameState();
        if (state == GameState.LOGIN_SCREEN || state == GameState.HOPPING) {
            this.oldXP.clear();
            this.newXP.clear();
            this.initialized = false;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        for (Skills skill : Skills.values()) {
            this.oldXP.put(skill.skill, this.client.getSkillExperience(skill.skill));
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        Player player = this.client.getLocalPlayer();
        if (!this.initialized) {
            this.initialized = true;
            return;
        }
        if (event.getContainerId() != INVENTORY.getId()) {
            return;
        }
        ItemContainer container = event.getItemContainer();
        if (container == null) {
            return;
        }
        for (Skills skill : Skills.values()) {
            this.newXP.put(skill.skill, this.client.getSkillExperience(skill.skill));
        }
        for (Skills skill : Skills.values()) {
            int thisOldXP = this.oldXP.get(skill.skill);
            int thisNewXP = this.newXP.get(skill.skill);
            if (thisNewXP <= thisOldXP) continue;
            this.oldXP.replace(skill.skill, thisNewXP);
            if (!skill.isEnabled()) continue;
            player.setOverheadText(skill.getMessage());
            player.setOverheadCycle(70);
            break;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("ivegotwood")) {
            this.updateSkills();
        }
    }

    @Provides
    IveGotWoodConfig provideConfig(ConfigManager configManager) {
        return (IveGotWoodConfig)configManager.getConfig(IveGotWoodConfig.class);
    }

    private static enum Skills {
        WOODCUTTING(Skill.WOODCUTTING, "", true),
        FISHING(Skill.FISHING, "", true),
        MINING(Skill.MINING, "", true),
        CONSTRUCTION(Skill.CONSTRUCTION, "", true);

        private final Skill skill;
        private String message;
        private boolean enabled;

        private Skills(Skill skill, String message, Boolean enabled) {
            this.skill = skill;
            this.message = message;
            this.enabled = enabled;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

