/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.ui;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.hydrox.transmog.TransmogPreset;
import io.hydrox.transmog.ui.CustomTab;
import io.hydrox.transmog.ui.EquipmentOverlay;
import io.hydrox.transmog.ui.MainTab;
import io.hydrox.transmog.ui.PresetTab;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.MouseWheelEvent;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.ui.FontManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UIManager {
    private static final Logger log = LoggerFactory.getLogger(UIManager.class);
    public static final String FORCE_RIGHT_CLICK_WIDGET_NAME = "<col=004356>";
    public static final String ORANGE_COLOUR_WIDGET_NAME = "<col=ff981f>";
    static final FontMetrics FONT_METRICS = Toolkit.getDefaultToolkit().getFontMetrics(FontManager.getRunescapeSmallFont());
    private final ChatboxPanelManager chatboxPanelManager;
    private final Client client;
    private final ClientThread clientThread;
    private final Provider<MainTab> mainTab;
    private final Provider<EquipmentOverlay> equipmentOverlay;
    private final Provider<PresetTab> presetTab;
    private boolean uiCreated = false;
    private boolean isSearching = false;
    CustomTab currentTab;

    public MainTab getMainTab() {
        return (MainTab)this.mainTab.get();
    }

    public EquipmentOverlay getEquipmentOverlay() {
        return (EquipmentOverlay)this.equipmentOverlay.get();
    }

    public PresetTab getPresetTab() {
        return (PresetTab)this.presetTab.get();
    }

    @Inject
    UIManager(ChatboxPanelManager chatboxPanelManager, Client client, ClientThread clientThread, Provider<MainTab> mainTab, Provider<EquipmentOverlay> equipmentOverlay, Provider<PresetTab> presetTab) {
        this.chatboxPanelManager = chatboxPanelManager;
        this.client = client;
        this.clientThread = clientThread;
        this.mainTab = mainTab;
        this.equipmentOverlay = equipmentOverlay;
        this.presetTab = presetTab;
    }

    public void shutDown() {
        this.clientThread.invoke(this::removeCustomUI);
        this.uiCreated = false;
        this.closeSearch();
        this.currentTab.shutDown();
    }

    public void createTab(CustomTab tab) {
        this.currentTab = tab;
        this.currentTab.create();
    }

    public void onPvpChanged(boolean newValue) {
        this.currentTab.onPvpChanged(newValue);
    }

    public void onResizeableChanged() {
        this.uiCreated = false;
        this.removeCustomUI();
        this.createTab((CustomTab)this.equipmentOverlay.get());
    }

    Widget getContainer() {
        Widget equipment = this.client.getWidget(387, 0);
        return equipment.getParent();
    }

    void closeSearch() {
        if (this.isSearching) {
            this.chatboxPanelManager.close();
            this.isSearching = false;
        }
    }

    void hideVanillaUI() {
        for (Widget child : this.getContainer().getNestedChildren()) {
            child.setHidden(true);
            child.revalidate();
        }
    }

    public void removeCustomUI() {
        Widget parent = this.getContainer();
        parent.deleteAllChildren();
        for (Widget child : parent.getNestedChildren()) {
            child.setHidden(false);
            child.revalidate();
        }
        this.currentTab.destroy();
        parent.revalidate();
        this.closeSearch();
    }

    public void loadPreset(TransmogPreset preset) {
        if (this.currentTab != null) {
            this.currentTab.loadPreset(preset);
        }
    }

    public void onClientTick() {
        if (this.currentTab != null) {
            this.currentTab.onClientTick();
        }
    }

    public void updateTutorial(boolean equipmentState) {
        if (this.currentTab != null) {
            this.currentTab.updateTutorial(equipmentState);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this.currentTab != null) {
            this.currentTab.mouseWheelMoved(event);
        }
    }

    public static String cutStringToPxWidth(String str, int targetWidth) {
        return UIManager.cutStringToPxWidth(str, targetWidth, false);
    }

    public static String cutStringToPxWidth(String str, int targetWidth, boolean withEllipsis) {
        int width = FONT_METRICS.stringWidth(str);
        String newStr = str;
        while (width > targetWidth) {
            newStr = newStr.substring(0, newStr.length() - 1);
            width = FONT_METRICS.stringWidth(newStr + (withEllipsis ? "..." : ""));
        }
        return newStr + (withEllipsis ? "..." : "");
    }

    public boolean isUiCreated() {
        return this.uiCreated;
    }

    public void setUiCreated(boolean uiCreated) {
        this.uiCreated = uiCreated;
    }

    public boolean isSearching() {
        return this.isSearching;
    }

    public void setSearching(boolean isSearching) {
        this.isSearching = isSearching;
    }
}

