/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.ui;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.hydrox.transmog.TransmogPreset;
import io.hydrox.transmog.TransmogrificationManager;
import io.hydrox.transmog.config.TransmogrificationConfigManager;
import io.hydrox.transmog.ui.CustomTab;
import io.hydrox.transmog.ui.CustomWidget;
import io.hydrox.transmog.ui.CustomWidgetActionButton;
import io.hydrox.transmog.ui.CustomWidgetActionButtonWithText;
import io.hydrox.transmog.ui.CustomWidgetAddPresetButton;
import io.hydrox.transmog.ui.CustomWidgetPresetBox;
import io.hydrox.transmog.ui.CustomWidgetPresetTabItem;
import io.hydrox.transmog.ui.UIManager;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;

@Singleton
public class PresetTab
extends CustomTab {
    private static final int SCROLLBAR_HEIGHT = 203;
    private static final int SCROLLBAR_WIDTH = 16;
    private static final int SCROLLBAR_BUTTON_HEIGHT = 16;
    private static final int SCROLLBAR_PADDING = 1;
    private static final int SCROLLBAR_TRACK_HEIGHT = 171;
    private static final int SCROLLBAR_THUMB_CAP_HEIGHT = 5;
    private static final int PRESETS_PER_LINE = 4;
    private static final int PRESET_PADDING = 11;
    private static final int PRESET_EDGE_PADDING = 4;
    private static final int BACK_BUTTON_SPRITE = 1122;
    private final Client client;
    private final ClientThread clientThread;
    private final TransmogrificationConfigManager config;
    private final TransmogrificationManager manager;
    private final Provider<UIManager> uiManager;
    private Widget[] presetScrollbars;
    private Rectangle boxBounds;
    private int scrollPos = 0;
    private int maxScrollPos = 0;
    private List<CustomWidgetPresetTabItem> presets = new ArrayList<CustomWidgetPresetTabItem>();

    @Inject
    PresetTab(Client client, ClientThread clientThread, TransmogrificationConfigManager config, TransmogrificationManager manager, Provider<UIManager> uiManager) {
        this.client = client;
        this.clientThread = clientThread;
        this.config = config;
        this.manager = manager;
        this.uiManager = uiManager;
    }

    private UIManager getUIManager() {
        return (UIManager)this.uiManager.get();
    }

    @Override
    void create() {
        Widget parent = this.getUIManager().getContainer();
        this.boxBounds = parent.getBounds();
        this.presets.clear();
        AtomicInteger index = new AtomicInteger();
        this.manager.getPresets().stream().filter(Objects::nonNull).forEach(preset -> {
            int i = index.getAndIncrement();
            this.presets.add(this.createPresetBox((TransmogPreset)preset, parent, i));
        });
        CustomWidgetAddPresetButton w = new CustomWidgetAddPresetButton(parent, "Preset", this::addNewPreset);
        ((CustomWidget)w).create();
        ((CustomWidgetPresetTabItem)w).layout(4 + index.get() % 4 * 43, 4 + index.get() / 4 * 43);
        w.addOption(1, "Create new");
        this.presets.add(w);
        this.maxScrollPos = Math.max(((int)Math.ceil((double)this.presets.size() / 4.0) - 5) * 43 + 12 + 1, 0);
        Widget scrollUp = parent.createChild(-1, 5);
        scrollUp.setOriginalWidth(16);
        scrollUp.setOriginalHeight(16);
        scrollUp.setSpriteId(773);
        scrollUp.setOriginalX(parent.getOriginalWidth() - 16 - 1);
        scrollUp.setOriginalY(0);
        scrollUp.revalidate();
        Widget scrollDown = parent.createChild(-1, 5);
        scrollDown.setOriginalWidth(16);
        scrollDown.setOriginalHeight(16);
        scrollDown.setSpriteId(788);
        scrollDown.setOriginalX(parent.getOriginalWidth() - 16 - 1);
        scrollDown.setOriginalY(186);
        scrollDown.revalidate();
        Widget scrollBg = parent.createChild(-1, 5);
        scrollBg.setOriginalWidth(16);
        scrollBg.setOriginalHeight(171);
        scrollBg.setSpriteId(792);
        scrollBg.setOriginalX(parent.getOriginalWidth() - 16 - 1);
        scrollBg.setOriginalY(16);
        scrollBg.setHasListener(true);
        scrollBg.setOnClickListener(new Object[]{ev -> this.scrollTo(this.client.getMouseCanvasPosition().getY() - parent.getBounds().y)});
        scrollBg.revalidate();
        Widget scrollBarTop = parent.createChild(-1, 5);
        scrollBarTop.setOriginalWidth(16);
        scrollBarTop.setOriginalHeight(5);
        scrollBarTop.setSpriteId(789);
        scrollBarTop.setOriginalX(parent.getOriginalWidth() - 16 - 1);
        scrollBarTop.setOriginalY(16);
        scrollBarTop.setNoClickThrough(false);
        scrollBarTop.setHasListener(true);
        scrollBarTop.revalidate();
        Widget scrollBarBottom = parent.createChild(-1, 5);
        scrollBarBottom.setOriginalWidth(16);
        scrollBarBottom.setOriginalHeight(5);
        scrollBarBottom.setSpriteId(791);
        scrollBarBottom.setOriginalX(parent.getOriginalWidth() - 16 - 1);
        scrollBarBottom.setOriginalY(16);
        scrollBarBottom.setNoClickThrough(false);
        scrollBarBottom.setHasListener(true);
        scrollBarBottom.revalidate();
        Widget scrollBarCentre = parent.createChild(-1, 5);
        scrollBarCentre.setOriginalWidth(16);
        scrollBarCentre.setOriginalHeight(0);
        scrollBarCentre.setSpriteId(790);
        scrollBarCentre.setOriginalX(parent.getOriginalWidth() - 16 - 1);
        scrollBarCentre.setOriginalY(16);
        scrollBarCentre.setNoClickThrough(false);
        scrollBarCentre.setHasListener(true);
        scrollBarCentre.revalidate();
        Widget scrollBarControl = parent.createChild(-1, 5);
        scrollBarControl.setOriginalWidth(16);
        scrollBarControl.setOriginalHeight(0);
        scrollBarControl.setOriginalX(parent.getOriginalWidth() - 16 - 1);
        scrollBarControl.setOriginalY(16);
        scrollBarControl.setHasListener(true);
        scrollBarControl.setDragParent(scrollBg);
        scrollBarControl.setNoClickThrough(false);
        scrollBarControl.setOnDragListener(new Object[]{ev -> this.scrollTo(this.client.getMouseCanvasPosition().getY() - parent.getBounds().y)});
        scrollBarControl.revalidate();
        this.presetScrollbars = new Widget[]{scrollBarTop, scrollBarBottom, scrollBarCentre, scrollBarControl};
        this.layoutScrollbar();
        Widget cover = parent.createChild(-1, 5);
        cover.setSpriteId(897);
        cover.setSpriteTiling(true);
        cover.setOriginalX(0);
        cover.setOriginalY(204);
        cover.setOriginalWidth(parent.getOriginalWidth());
        cover.setOriginalHeight(parent.getOriginalHeight() - 204);
        cover.revalidate();
        CustomWidgetActionButtonWithText selectPresetButton = new CustomWidgetActionButtonWithText(parent, "", 1122, "", op -> {
            this.getUIManager().removeCustomUI();
            this.getUIManager().hideVanillaUI();
            this.getUIManager().getEquipmentOverlay().create(true);
            this.getUIManager().createTab(this.getUIManager().getMainTab());
        });
        selectPresetButton.setSize(40, 40);
        selectPresetButton.setIconSize(25, 20);
        selectPresetButton.create();
        selectPresetButton.addOption(1, "Back");
        selectPresetButton.layout(7, 213);
        Widget separator = parent.createChild(-1, 9);
        separator.setOriginalX(-1);
        separator.setOriginalY(203);
        separator.setXPositionMode(1);
        separator.setYPositionMode(0);
        separator.setOriginalHeight(0);
        separator.setOriginalWidth(6);
        separator.setWidthMode(1);
        separator.setTextColor(11181941);
        separator.revalidate();
        CustomWidgetActionButton deletePresetButton = new CustomWidgetActionButton(parent, "<col=004356>", 1235, op -> {
            int i;
            TransmogPreset current = this.manager.getCurrentPreset();
            this.manager.deletePreset(current.getId());
            for (i = current.getId() - 1; i >= 0; --i) {
                if (this.manager.getPreset(i) == null) continue;
                this.selectPreset(i);
                return;
            }
            for (i = current.getId() + 1; i <= this.config.lastIndex(); ++i) {
                if (this.manager.getPreset(i) == null) continue;
                this.selectPreset(i);
                return;
            }
        });
        deletePresetButton.setSize(40, 40);
        deletePresetButton.setIconSize(26, 20);
        deletePresetButton.create();
        deletePresetButton.addOption(1, "Delete active <col=ff981f>Preset");
        deletePresetButton.layout(52, 213);
        parent.revalidate();
        this.presets.stream().filter(b -> b.getId() == this.config.currentPreset()).findFirst().ifPresent(box -> this.scrollTo(box.y));
    }

    void recreate() {
        Widget parent = this.getUIManager().getContainer();
        parent.deleteAllChildren();
        this.create();
    }

    private CustomWidgetPresetTabItem createPresetBox(TransmogPreset preset, Widget parent, int i) {
        CustomWidgetPresetBox w = new CustomWidgetPresetBox(preset, parent, this::selectPreset);
        ((CustomWidget)w).create();
        ((CustomWidgetPresetTabItem)w).layout(4 + i % 4 * 43, 4 + i / 4 * 43);
        if (preset.getId() == this.config.currentPreset()) {
            w.setSelected(true);
        }
        w.addOption(1, "Select");
        return w;
    }

    private void selectPreset(int id) {
        this.presets.forEach(b -> b.setSelected(b.getId() == id));
        this.config.currentPreset(id);
        this.manager.updateTransmog();
        this.recreate();
    }

    private void addNewPreset(int id) {
        TransmogPreset newPreset = this.manager.createNewPreset();
        CustomWidgetPresetTabItem add = this.presets.get(this.presets.size() - 1);
        add.layout(this.presets.size() % 4 * 43, this.presets.size() / 4 * 43);
        this.presets.add(this.presets.size() - 1, this.createPresetBox(newPreset, this.getUIManager().getContainer(), this.presets.size() - 1));
        this.selectPreset(newPreset.getId());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this.boxBounds != null && this.boxBounds.contains(event.getPoint())) {
            this.clientThread.invoke(() -> this.scrollPresets(event.getUnitsToScroll() * 6));
        }
    }

    private void scrollPresets(int pixels) {
        this.scrollPos += pixels;
        this.doScroll();
    }

    private void scrollTo(int ypos) {
        int thumbHeight = Math.max((int)(203.0 / (double)(this.maxScrollPos + 203) * 171.0), 10);
        int thumbCentRange = 171 - thumbHeight;
        int thumbCentTop = 16 + thumbHeight / 2;
        double centrePer = Math.min(1.0, Math.max(0.0, (double)(ypos - thumbCentTop) / (double)thumbCentRange));
        this.scrollPos = (int)(centrePer * (double)this.maxScrollPos);
        this.doScroll();
    }

    private void doScroll() {
        this.scrollPos = Math.max(0, Math.min(this.scrollPos, this.maxScrollPos));
        this.layoutScrollbar();
        for (CustomWidgetPresetTabItem p : this.presets) {
            p.scrollBy(this.scrollPos);
        }
    }

    private void layoutScrollbar() {
        int thumbHeight = Math.max((int)(203.0 / (double)(this.maxScrollPos + 203) * 171.0), 10);
        int thumbBuffer = 171 - thumbHeight;
        int thumbTop = (int)((double)this.scrollPos / (double)this.maxScrollPos * (double)thumbBuffer);
        this.presetScrollbars[0].setOriginalY(16 + thumbTop);
        this.presetScrollbars[1].setOriginalY(16 + thumbTop + thumbHeight - 5 - 1);
        this.presetScrollbars[2].setOriginalY(16 + thumbTop + 5);
        this.presetScrollbars[2].setOriginalHeight(thumbHeight - 10);
        this.presetScrollbars[3].setOriginalY(16 + thumbTop);
        this.presetScrollbars[3].setOriginalHeight(thumbHeight);
        Arrays.stream(this.presetScrollbars).forEach(Widget::revalidate);
    }
}

