/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.ui;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.hydrox.transmog.FacialHairMapping;
import io.hydrox.transmog.HairMapping;
import io.hydrox.transmog.Mapping;
import io.hydrox.transmog.MappingMapping;
import io.hydrox.transmog.SleeveMapping;
import io.hydrox.transmog.TransmogPartyManager;
import io.hydrox.transmog.TransmogPreset;
import io.hydrox.transmog.TransmogSlot;
import io.hydrox.transmog.TransmogrificationManager;
import io.hydrox.transmog.TransmogrificationPlugin;
import io.hydrox.transmog.config.TransmogrificationConfigManager;
import io.hydrox.transmog.ui.CustomItemSearch;
import io.hydrox.transmog.ui.CustomSpriteSearch;
import io.hydrox.transmog.ui.CustomSprites;
import io.hydrox.transmog.ui.CustomTab;
import io.hydrox.transmog.ui.CustomWidget;
import io.hydrox.transmog.ui.CustomWidgetActionButton;
import io.hydrox.transmog.ui.CustomWidgetBlockerBox;
import io.hydrox.transmog.ui.CustomWidgetConfigButton;
import io.hydrox.transmog.ui.CustomWidgetNamePlate;
import io.hydrox.transmog.ui.CustomWidgetPlayerPreview;
import io.hydrox.transmog.ui.CustomWidgetToggleButton;
import io.hydrox.transmog.ui.CustomWidgetTransmogBox;
import io.hydrox.transmog.ui.UIManager;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.chatbox.ChatboxItemSearch;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.tuple.Pair;

@Singleton
public class MainTab
extends CustomTab {
    private static final Point BASE_POSITION = new Point(148, 4);
    private static final ImmutableMap<TransmogSlot, Point> SLOT_POSITIONS = ImmutableMap.builder().put((Object)TransmogSlot.JAW, (Object)new Point(-76, 0)).put((Object)TransmogSlot.HAIR, (Object)new Point(-38, 0)).put((Object)TransmogSlot.HEAD, (Object)new Point(0, 0)).put((Object)TransmogSlot.CAPE, (Object)new Point(-38, 38)).put((Object)TransmogSlot.NECK, (Object)new Point(0, 38)).put((Object)TransmogSlot.SLEEVES, (Object)new Point(-56, 76)).put((Object)TransmogSlot.TORSO, (Object)new Point(0, 76)).put((Object)TransmogSlot.LEGS, (Object)new Point(0, 115)).put((Object)TransmogSlot.HANDS, (Object)new Point(-56, 154)).put((Object)TransmogSlot.BOOTS, (Object)new Point(0, 154)).build();
    private static final List<Pair<Rectangle, Integer>> INTER_SLOT_BRACERS = ImmutableList.builder().add((Object)Pair.of((Object)new Rectangle(0, 36, 36, 122), (Object)172)).add((Object)Pair.of((Object)new Rectangle(-56, 114, 36, 44), (Object)172)).add((Object)Pair.of((Object)new Rectangle(-46, 0, 46, 36), (Object)173)).add((Object)Pair.of((Object)new Rectangle(-5, 39, 5, 36), (Object)173)).add((Object)Pair.of((Object)new Rectangle(-20, 78, 20, 36), (Object)173)).build();
    private final ChatboxPanelManager chatboxPanelManager;
    private final ChatboxItemSearch allItemSearch;
    private final CustomItemSearch slotItemSearch;
    private final CustomSpriteSearch spriteSearch;
    private final ItemManager itemManager;
    private final TransmogPartyManager partyManager;
    private final TransmogrificationManager manager;
    private final UIManager uiManager;
    private final TransmogrificationConfigManager config;
    private final Map<TransmogSlot, CustomWidgetTransmogBox> uiSlots = new HashMap<TransmogSlot, CustomWidgetTransmogBox>();
    private Widget helpText;
    private CustomWidgetPlayerPreview playerPreview;
    private CustomWidgetActionButton saveDefaultStateButton;
    private CustomWidgetBlockerBox blockerBox;
    private CustomWidgetConfigButton presetExtraDataButton;
    private CustomWidgetNamePlate nameplate;

    @Inject
    MainTab(ChatboxPanelManager chatboxPanelManager, ChatboxItemSearch allItemSearch, CustomItemSearch slotItemSearch, CustomSpriteSearch spriteSearch, ItemManager itemManager, TransmogrificationPlugin plugin, TransmogrificationManager manager, TransmogPartyManager partyManager, TransmogrificationConfigManager config) {
        this.chatboxPanelManager = chatboxPanelManager;
        this.allItemSearch = allItemSearch;
        this.slotItemSearch = slotItemSearch;
        this.spriteSearch = spriteSearch;
        this.itemManager = itemManager;
        this.partyManager = partyManager;
        this.manager = manager;
        this.uiManager = plugin.getUIManager();
        this.config = config;
    }

    @Override
    void shutDown() {
        this.uiSlots.clear();
    }

    @Override
    void destroy() {
        this.playerPreview = null;
    }

    @Override
    void create() {
        Widget parent = this.uiManager.getContainer();
        this.uiManager.getEquipmentOverlay().create(true);
        this.helpText = parent.createChild(-1, 4);
        this.helpText.setTextColor(CustomWidget.fromRGB(Color.YELLOW));
        this.helpText.setTextShadowed(true);
        this.helpText.setFontId(494);
        this.helpText.setOriginalWidth(90);
        this.helpText.setOriginalHeight(150);
        this.helpText.setOriginalX(3);
        this.helpText.setOriginalY(60);
        this.helpText.setText("Choose the items you want to see yourself wearing. If you're having glitchy collision, remove your hair/sleeves/beard. Removing hair requires toggling the transmog. Please report broken items to the support link.");
        this.helpText.setHidden(true);
        this.helpText.revalidate();
        this.playerPreview = new CustomWidgetPlayerPreview(parent, "Preview");
        this.playerPreview.create();
        this.playerPreview.layout(3, 60);
        CustomWidgetToggleButton guideButton = new CustomWidgetToggleButton(parent, "Help", 195, 196, CustomSprites.QUESTION_MARK.getSpriteId(), selected -> {
            this.helpText.setHidden(!selected);
            this.playerPreview.setHidden(selected);
        });
        guideButton.setVerbs("Show", "Hide");
        guideButton.setSize(25, 25);
        guideButton.setIconSize(8, 17);
        guideButton.create();
        guideButton.layout(3, 30);
        CustomWidgetToggleButton shareButton = new CustomWidgetToggleButton(parent, "Share to Party", 195, 196, CustomSprites.PARTY.getSpriteId(), this.partyManager::setShareWithParty);
        shareButton.setVerbs("Enable", "Disable");
        shareButton.setSize(25, 25);
        shareButton.setIconSize(19, 19);
        shareButton.create();
        if (this.config.transmitToParty()) {
            shareButton.toggle();
        }
        shareButton.layout(30, 30);
        CustomWidgetActionButton selectPresetButton = new CustomWidgetActionButton(parent, "", 909, op -> {
            this.uiManager.removeCustomUI();
            this.uiManager.hideVanillaUI();
            this.uiManager.createTab(this.uiManager.getPresetTab());
        });
        selectPresetButton.setSize(40, 40);
        selectPresetButton.setIconSize(36, 36);
        selectPresetButton.create();
        selectPresetButton.addOption(1, "Choose <col=ff981f>Preset");
        selectPresetButton.layout(7, 213);
        this.presetExtraDataButton = new CustomWidgetConfigButton(parent, "<col=004356>", op -> {
            switch (op) {
                case 1: {
                    this.chatboxPanelManager.openTextInput("Set name for this preset").value(Strings.nullToEmpty((String)this.manager.getCurrentPreset().getName())).onDone(content -> {
                        if (content == null) {
                            return;
                        }
                        content = Text.removeTags((String)content).trim();
                        this.manager.getCurrentPreset().setName((String)content);
                        this.manager.saveCurrentPreset();
                        this.nameplate.setText(this.manager.getCurrentPreset().getDisplayName());
                    }).build();
                    break;
                }
                case 2: {
                    this.allItemSearch.tooltipText("Select").onItemSelected(itemId -> {
                        this.manager.getCurrentPreset().setIcon((int)itemId);
                        this.manager.saveCurrentPreset();
                        this.presetExtraDataButton.setItemIcon((int)itemId);
                    }).prompt("Select icon for this preset").build();
                    break;
                }
                case 3: {
                    this.manager.getCurrentPreset().setIcon(-1);
                    this.manager.saveCurrentPreset();
                    this.presetExtraDataButton.setItemIcon(-1);
                }
            }
        });
        this.presetExtraDataButton.setSize(40, 40);
        this.presetExtraDataButton.create();
        this.presetExtraDataButton.addOption(0, "<col=ff981f>Preset Config:");
        this.presetExtraDataButton.addOption(1, "Set Name");
        this.presetExtraDataButton.setItemIcon(this.manager.getCurrentPreset().getIcon());
        this.presetExtraDataButton.layout(97, 213);
        this.saveDefaultStateButton = new CustomWidgetActionButton(parent, "Default State", 115, op -> {
            if (this.manager.updateDefault(op)) {
                this.saveDefaultStateButton.setIconSprite(115);
                this.blockerBox.setHidden(true);
            }
        });
        this.saveDefaultStateButton.setSize(40, 40);
        this.saveDefaultStateButton.setIconSize(30, 30);
        this.saveDefaultStateButton.create();
        this.saveDefaultStateButton.setIconSprite(this.manager.isDefaultStateSet() ? 115 : 118);
        this.saveDefaultStateButton.addOption(1, "Save as");
        this.saveDefaultStateButton.addOption(2, "Force save as");
        this.saveDefaultStateButton.layout(142, 213);
        for (Pair<Rectangle, Integer> bracer : INTER_SLOT_BRACERS) {
            Rectangle posData = (Rectangle)bracer.getLeft();
            Widget bracerWidget = parent.createChild(-1, 5);
            bracerWidget.setOriginalX(BASE_POSITION.getX() + posData.x);
            bracerWidget.setOriginalY(BASE_POSITION.getY() + posData.y);
            bracerWidget.setOriginalWidth(posData.width);
            bracerWidget.setOriginalHeight(posData.height);
            bracerWidget.setSpriteId(((Integer)bracer.getRight()).intValue());
            bracerWidget.setSpriteTiling(true);
            bracerWidget.revalidate();
        }
        TransmogPreset preset = this.manager.getCurrentPreset();
        for (TransmogSlot slot : TransmogSlot.values()) {
            CustomWidgetTransmogBox box;
            if (slot.getSlotType() == TransmogSlot.SlotType.ITEM) {
                box = new CustomWidgetTransmogBox(TransmogSlot.SlotType.ITEM, parent, slot, this::onTransmogUISlotClicked);
                box.create();
                Integer item = preset.getIdForSlot(slot, false);
                if (item == null) {
                    box.setEmpty();
                } else if (item == -1) {
                    box.setDefault();
                } else {
                    box.set(item, this.itemManager.getItemComposition(item.intValue()).getName());
                }
            } else {
                box = new CustomWidgetTransmogBox(TransmogSlot.SlotType.SPECIAL, parent, slot, this::onTransmogUISlotClicked);
                box.create();
                Integer contents = preset.getIdForSlot(slot, false);
                if (contents == null) {
                    box.setEmpty();
                } else if (contents == -1) {
                    box.setDefault();
                } else {
                    Mapping mapping = MappingMapping.fromSlot(slot).getFromModel().apply(contents);
                    box.set(mapping.modelId(), mapping.prettyName());
                }
            }
            Point pos = (Point)SLOT_POSITIONS.get((Object)slot);
            box.layout(BASE_POSITION.getX() + pos.getX(), BASE_POSITION.getY() + pos.getY());
            this.uiSlots.put(slot, box);
        }
        this.blockerBox = new CustomWidgetBlockerBox(parent, "");
        this.blockerBox.setSize(parent.getWidth(), parent.getHeight());
        this.blockerBox.create();
        this.blockerBox.layout(0, 0);
        if (this.manager.isDefaultStateSet()) {
            this.blockerBox.setHidden(true);
        }
        this.nameplate = new CustomWidgetNamePlate(parent, 92);
        this.nameplate.create();
        this.nameplate.setText(this.manager.getCurrentPreset().getDisplayName());
        this.nameplate.layout(92, 196);
        this.updateTutorial(this.manager.isEmptyEquipment());
        parent.revalidate();
        this.manager.updateTransmog();
    }

    @Override
    void onClientTick() {
        if (this.playerPreview != null) {
            this.playerPreview.tickRotation();
        }
    }

    @Override
    public void updateTutorial(boolean equipmentState) {
        if (!this.manager.isDefaultStateSet() && this.blockerBox != null) {
            this.blockerBox.setTutorialState(equipmentState ? 2 : 1);
        }
    }

    @Override
    public void loadPreset(TransmogPreset preset) {
        for (TransmogSlot slot : TransmogSlot.values()) {
            this.uiSlots.get((Object)slot).set(preset.getIdForSlot(slot, false), preset.getName(slot));
        }
    }

    private void onTransmogUISlotClicked(int op, TransmogSlot slot) {
        CustomWidgetTransmogBox widget = this.uiSlots.get((Object)slot);
        TransmogPreset preset = this.manager.getCurrentPreset();
        switch (op) {
            case 1: {
                if (this.uiManager.isSearching()) {
                    this.uiManager.closeSearch();
                }
                this.uiManager.setSearching(true);
                if (slot.getSlotType() == TransmogSlot.SlotType.SPECIAL) {
                    CustomSpriteSearch s = this.spriteSearch;
                    s.setTooltipText("Set as " + slot.getName());
                    s.setPrompt("Choose for " + slot.getName() + " slot");
                    s.setSlot(slot);
                    s.setOnItemSelected(m -> {
                        widget.setContent(m.modelId(), m.prettyName());
                        this.uiManager.setSearching(false);
                        preset.setSlot(slot, m.kitId(), m.prettyName());
                        this.manager.updateTransmog();
                        this.manager.saveCurrentPreset();
                    });
                    switch (slot) {
                        case HAIR: {
                            s.setSource(HairMapping.values());
                            break;
                        }
                        case JAW: {
                            s.setSource(FacialHairMapping.values());
                            break;
                        }
                        case SLEEVES: {
                            s.setSource(SleeveMapping.values());
                        }
                    }
                    s.build();
                    break;
                }
                CustomItemSearch i = this.slotItemSearch;
                i.setTooltipText("Set as " + slot.getName());
                i.setPrompt("Choose for " + slot.getName() + " slot");
                i.setSlot(slot);
                i.setOnItemSelected((id, name) -> {
                    widget.setContent((int)id, (String)name);
                    this.uiManager.setSearching(false);
                    preset.setSlot(slot, (int)id, (String)name);
                    this.manager.updateTransmog();
                    this.manager.saveCurrentPreset();
                });
                i.build();
                break;
            }
            case 3: {
                this.chatboxPanelManager.close();
                widget.setEmpty();
                preset.clearSlot(slot);
                this.manager.updateTransmog();
                this.manager.saveCurrentPreset();
                break;
            }
            case 5: {
                this.chatboxPanelManager.close();
                widget.setDefault();
                preset.setDefaultSlot(slot);
                this.manager.updateTransmog();
                this.manager.saveCurrentPreset();
            }
        }
    }

    public Map<TransmogSlot, CustomWidgetTransmogBox> getUiSlots() {
        return this.uiSlots;
    }
}

