/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.ui;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.hydrox.transmog.TransmogrificationManager;
import io.hydrox.transmog.TransmogrificationPlugin;
import io.hydrox.transmog.config.TransmogrificationConfigManager;
import io.hydrox.transmog.ui.CustomSprites;
import io.hydrox.transmog.ui.CustomTab;
import io.hydrox.transmog.ui.CustomWidgetToggleButton;
import io.hydrox.transmog.ui.UIManager;
import net.runelite.api.widgets.Widget;

@Singleton
public class EquipmentOverlay
extends CustomTab {
    private CustomWidgetToggleButton stateToggle;
    private Widget pvpBlocker;
    private final TransmogrificationConfigManager config;
    private final TransmogrificationManager manager;
    private final UIManager uiManager;

    @Inject
    EquipmentOverlay(TransmogrificationPlugin plugin, TransmogrificationConfigManager config, TransmogrificationManager manager) {
        this.config = config;
        this.manager = manager;
        this.uiManager = plugin.getUIManager();
    }

    @Override
    void create() {
        this.create(false);
    }

    void create(boolean uiActive) {
        Widget parent = this.uiManager.getContainer();
        CustomWidgetToggleButton showUI = new CustomWidgetToggleButton(parent, "Transmogrification", 195, 196, 1654, selected -> {
            if (selected) {
                this.uiManager.hideVanillaUI();
                this.uiManager.createTab(this.uiManager.getMainTab());
            } else {
                this.uiManager.removeCustomUI();
                this.create(false);
                this.manager.savePresets();
            }
        });
        showUI.setVerbs("Edit", "Exit");
        showUI.setSize(25, 25);
        showUI.setIconSize(32, 32);
        showUI.create();
        if (uiActive) {
            showUI.toggle();
        }
        showUI.layout(3, 3);
        this.stateToggle = new CustomWidgetToggleButton(parent, "Transmogrification", 195, 196, CustomSprites.TRANSMOG_LOGO.getSpriteId(), state -> {
            if (!this.manager.isDefaultStateSet() && state || this.manager.isInPvpSituation()) {
                this.stateToggle.toggle();
                this.manager.hintDefaultState();
                return;
            }
            this.config.transmogActive(state);
            this.manager.updateTransmog();
        });
        this.stateToggle.setVerbs("Enable", "Disable");
        this.stateToggle.setSize(25, 25);
        this.stateToggle.setIconSize(16, 13);
        this.stateToggle.create();
        if (this.config.transmogActive() && this.manager.isDefaultStateSet()) {
            this.stateToggle.toggle();
        }
        this.stateToggle.layout(30, 3);
        this.pvpBlocker = parent.createChild(-1, 5);
        this.pvpBlocker.setSpriteId(1047);
        this.pvpBlocker.setOriginalWidth(25);
        this.pvpBlocker.setOriginalHeight(25);
        this.pvpBlocker.setHasListener(true);
        this.pvpBlocker.setNoClickThrough(true);
        this.pvpBlocker.setOnOpListener(new Object[]{e -> {}});
        this.pvpBlocker.setOriginalX(30);
        this.pvpBlocker.setOriginalY(3);
        this.pvpBlocker.setHidden(!this.manager.isInPvpSituation());
        this.pvpBlocker.setAction(0, "Transmog is disabled in PvP situations");
    }

    @Override
    void onPvpChanged(boolean newValue) {
        if (this.pvpBlocker != null) {
            this.pvpBlocker.setHidden(!newValue);
        }
    }
}

