/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.ui;

import io.hydrox.transmog.MappingMapping;
import io.hydrox.transmog.TransmogSlot;
import io.hydrox.transmog.ui.CustomWidget;
import io.hydrox.transmog.ui.InteractibleWidget;
import net.runelite.api.ScriptEvent;
import net.runelite.api.widgets.Widget;

public class CustomWidgetTransmogBox
extends CustomWidget
implements InteractibleWidget {
    private static final int BACKGROUND_ID = 170;
    private static final String SET_ITEM_STRING = "Set item for";
    private static final String CLEAR_STRING = "Clear";
    private static final String HIDE_STRING = "Hide";
    private static final String SPECIAL_CLEAR_STRING = "Follow armour for";
    private static final String SPECIAL_HIDE_STRING = "Use base";
    private Widget slotWidget;
    private Widget contentsWidget;
    private Widget slotDefaultWidget;
    private Widget overlayWidget;
    private TransmogSlot.SlotType type;
    private TransmogSlot slot;
    private MappingMapping mapping;
    private final InteractibleWidget.WidgetSlotCallback callback;

    public CustomWidgetTransmogBox(TransmogSlot.SlotType type, Widget parent, TransmogSlot slot, InteractibleWidget.WidgetSlotCallback callback) {
        super(parent, slot.getName());
        this.type = type;
        this.slot = slot;
        this.callback = callback;
    }

    public void setDefault() {
        this.slotDefaultWidget.setHidden(false);
        this.slotWidget.setHidden(false);
        this.contentsWidget.setHidden(true);
        this.overlayWidget.setAction(1, SET_ITEM_STRING);
        this.overlayWidget.setAction(5, null);
        if (this.slot.getSlotType() == TransmogSlot.SlotType.SPECIAL) {
            this.overlayWidget.setAction(3, SPECIAL_CLEAR_STRING);
        } else {
            this.overlayWidget.setAction(3, CLEAR_STRING);
        }
    }

    public void setEmpty() {
        this.slotDefaultWidget.setHidden(true);
        this.slotWidget.setHidden(false);
        this.contentsWidget.setHidden(true);
        this.overlayWidget.setAction(1, SET_ITEM_STRING);
        this.overlayWidget.setAction(3, null);
        if (this.slot.getSlotType() == TransmogSlot.SlotType.SPECIAL) {
            this.overlayWidget.setAction(5, SPECIAL_HIDE_STRING);
        } else {
            this.overlayWidget.setAction(5, HIDE_STRING);
        }
    }

    public void setContent(int id, String name) {
        this.slotDefaultWidget.setHidden(true);
        this.slotWidget.setHidden(true);
        this.contentsWidget.setHidden(false);
        if (this.type == TransmogSlot.SlotType.ITEM) {
            this.contentsWidget.setItemId(id);
        } else {
            this.contentsWidget.setModelId(id);
        }
        this.overlayWidget.setAction(1, "Replace <col=ff981f>" + name + "</col> for");
        if (this.slot.getSlotType() == TransmogSlot.SlotType.SPECIAL) {
            this.overlayWidget.setAction(3, SPECIAL_CLEAR_STRING);
            this.overlayWidget.setAction(5, SPECIAL_HIDE_STRING);
        } else {
            this.overlayWidget.setAction(3, CLEAR_STRING);
            this.overlayWidget.setAction(5, HIDE_STRING);
        }
    }

    public void set(Integer contents, String name) {
        if (contents == null) {
            this.setEmpty();
        } else if (contents == -1) {
            this.setDefault();
        } else {
            this.setContent(contents, name);
        }
    }

    @Override
    public void layout(int x, int y) {
        super.layout(x, y);
        int yOffset = this.mapping != null ? this.mapping.getYOffset() : 0;
        CustomWidgetTransmogBox.layoutWidget(this.base, x, y);
        CustomWidgetTransmogBox.layoutWidget(this.slotWidget, x + 2, y + 2);
        CustomWidgetTransmogBox.layoutWidget(this.slotDefaultWidget, x + 2, y + 2);
        CustomWidgetTransmogBox.layoutWidget(this.contentsWidget, x + 2, y + 2 + yOffset);
        CustomWidgetTransmogBox.layoutWidget(this.overlayWidget, x, y);
        this.parent.revalidate();
    }

    @Override
    public void create() {
        this.base = this.createSpriteWidget(36, 36);
        this.base.setSpriteId(170);
        this.slotWidget = this.createSpriteWidget(32, 32);
        this.slotWidget.setSpriteId(this.slot.getSpriteID());
        this.slotDefaultWidget = this.createSpriteWidget(32, 32);
        this.slotDefaultWidget.setSpriteId(1193);
        if (this.type == TransmogSlot.SlotType.ITEM) {
            this.contentsWidget = this.createSpriteWidget(36, 32);
            this.contentsWidget.setItemQuantity(-1);
            this.contentsWidget.setItemQuantityMode(2);
            this.contentsWidget.setBorderType(1);
        } else {
            this.mapping = MappingMapping.fromSlot(this.slot);
            this.contentsWidget = this.createModelWidget(36, 32);
            this.contentsWidget.setModelType(1);
            this.contentsWidget.setModelZoom(this.mapping.getModelZoom());
            this.contentsWidget.setRotationZ(150);
        }
        this.contentsWidget.setHidden(true);
        this.overlayWidget = this.createSpriteWidget(36, 36);
        this.overlayWidget.setOnOpListener(new Object[]{this::onButtonClicked});
        this.overlayWidget.setHasListener(true);
    }

    @Override
    public void onButtonClicked(ScriptEvent scriptEvent) {
        this.callback.run(scriptEvent.getOp() - 1, this.slot);
    }
}

