/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.ui;

import io.hydrox.transmog.ui.CustomWidgetWithIcon;
import io.hydrox.transmog.ui.InteractibleWidget;
import net.runelite.api.ScriptEvent;
import net.runelite.api.widgets.Widget;

public class CustomWidgetToggleButton
extends CustomWidgetWithIcon
implements InteractibleWidget {
    private int selectedBackgroundSprite;
    private int backgroundSpriteID;
    private String verbWhenOff;
    private String verbWhenOn;
    private boolean selected;
    private final InteractibleWidget.WidgetBooleanCallback callback;
    private Widget clickbox;

    public CustomWidgetToggleButton(Widget parent, String name, int backgroundSprite, int selectedBackgroundSprite, int iconSprite, InteractibleWidget.WidgetBooleanCallback callback) {
        super(parent, name, iconSprite);
        this.backgroundSpriteID = backgroundSprite;
        this.selectedBackgroundSprite = selectedBackgroundSprite;
        this.callback = callback;
    }

    public void setVerbs(String off, String on) {
        this.verbWhenOff = off;
        this.verbWhenOn = on;
    }

    public void toggle() {
        this.selected = !this.selected;
        this.base.setSpriteId(this.selected ? this.selectedBackgroundSprite : this.backgroundSpriteID);
        this.clickbox.setAction(1, this.selected ? this.verbWhenOn : this.verbWhenOff);
    }

    @Override
    public void layout(int x, int y) {
        CustomWidgetToggleButton.layoutWidget(this.base, x, y);
        CustomWidgetToggleButton.layoutWidget(this.clickbox, x, y);
        super.layout(x, y);
    }

    @Override
    public void create() {
        this.base = this.createSpriteWidget(this.width, this.height);
        this.base.setSpriteId(this.backgroundSpriteID);
        this.icon = this.createSpriteWidget(this.iconWidth, this.iconHeight);
        this.icon.setSpriteId(this.iconSpriteID);
        this.clickbox = this.createSpriteWidget(this.width, this.height);
        this.clickbox.setOnOpListener(new Object[]{this::onButtonClicked});
        this.clickbox.setOnMouseRepeatListener(new Object[]{e -> this.icon.setOpacity(120)});
        this.clickbox.setOnMouseLeaveListener(new Object[]{e -> this.icon.setOpacity(0)});
        this.clickbox.setHasListener(true);
        this.clickbox.setAction(1, this.verbWhenOff);
    }

    @Override
    public void onButtonClicked(ScriptEvent scriptEvent) {
        this.toggle();
        this.callback.run(this.selected);
    }
}

