/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.ui;

import io.hydrox.transmog.TransmogPreset;
import io.hydrox.transmog.ui.CustomWidgetPresetTabItem;
import io.hydrox.transmog.ui.InteractibleWidget;
import io.hydrox.transmog.ui.UIManager;
import java.awt.Color;
import net.runelite.api.ScriptEvent;
import net.runelite.api.widgets.Widget;

public class CustomWidgetPresetBox
extends CustomWidgetPresetTabItem {
    private static final int DEFAULT_ICON = 909;
    private static final int MAX_NAME_WIDTH_PX = 36;
    private Widget defaultIconWidget;
    private Widget iconWidget;
    private Widget nameWidget;
    private final TransmogPreset preset;

    public CustomWidgetPresetBox(TransmogPreset preset, Widget parent, InteractibleWidget.WidgetIntCallback callback) {
        super(parent, preset.getDisplayName(), callback);
        this.preset = preset;
    }

    @Override
    public int getId() {
        return this.preset.getId();
    }

    @Override
    public void layout(int x, int y) {
        super.layout(x, y);
        CustomWidgetPresetBox.layoutWidget(this.defaultIconWidget, x + 2, y + 2);
        CustomWidgetPresetBox.layoutWidget(this.nameWidget, x + 2, y + 2);
        CustomWidgetPresetBox.layoutWidget(this.iconWidget, x + 2, y + 2);
        this.parent.revalidate();
    }

    @Override
    public void scrollBy(int y) {
        super.scrollBy(y);
        this.defaultIconWidget.setOriginalY(this.y - y + 2);
        this.nameWidget.setOriginalY(this.y - y + 2);
        this.iconWidget.setOriginalY(this.y - y + 2);
        this.defaultIconWidget.revalidate();
        this.nameWidget.revalidate();
        this.iconWidget.revalidate();
    }

    @Override
    public void create() {
        super.createUnderlay();
        this.defaultIconWidget = this.createSpriteWidget(32, 32);
        this.defaultIconWidget.setSpriteId(909);
        this.iconWidget = this.createSpriteWidget(36, 32);
        this.iconWidget.setItemQuantity(-1);
        this.iconWidget.setItemQuantityMode(2);
        this.iconWidget.setBorderType(1);
        if (this.preset.getIcon() >= -1) {
            this.iconWidget.setItemId(this.preset.getIcon());
            this.defaultIconWidget.setHidden(true);
        } else {
            this.iconWidget.setHidden(true);
        }
        this.nameWidget = this.createTextWidget(UIManager.cutStringToPxWidth(this.preset.getDisplayName(), 36));
        this.nameWidget.setOriginalWidth(32);
        this.nameWidget.setOriginalHeight(32);
        this.nameWidget.setFontId(494);
        this.nameWidget.setTextColor(CustomWidgetPresetBox.fromRGB(Color.YELLOW));
        this.nameWidget.setXTextAlignment(2);
        this.nameWidget.setYTextAlignment(2);
        super.createOverlay();
    }

    @Override
    public void onButtonClicked(ScriptEvent scriptEvent) {
        this.callback.run(this.preset.getId());
    }
}

