/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.ui;

import io.hydrox.transmog.ui.CustomWidget;
import io.hydrox.transmog.ui.InteractibleWidget;
import net.runelite.api.ScriptEvent;
import net.runelite.api.widgets.Widget;

public class CustomWidgetPlayerPreview
extends CustomWidget
implements InteractibleWidget {
    private Widget clickbox;
    private boolean rotationEnabled = true;

    public CustomWidgetPlayerPreview(Widget parent, String name) {
        super(parent, name);
    }

    public void setHidden(boolean state) {
        this.base.setHidden(state);
        this.clickbox.setHidden(state);
    }

    @Override
    public void layout(int x, int y) {
        super.layout(x, y);
        CustomWidgetPlayerPreview.layoutWidget(this.base, x, y + 60);
        CustomWidgetPlayerPreview.layoutWidget(this.clickbox, x, y);
        this.parent.revalidate();
    }

    @Override
    public void create() {
        this.base = this.createModelWidget(90, 150);
        this.base.setModelId(1);
        this.base.setModelType(5);
        this.base.setModelZoom(760);
        this.base.setRotationX(150);
        this.clickbox = this.createSpriteWidget(90, 150);
        this.clickbox.setHasListener(true);
        this.clickbox.setOnOpListener(new Object[]{this::onButtonClicked});
        this.clickbox.setAction(1, "Toggle rotation for");
        this.clickbox.setAction(2, "Reset rotation for");
    }

    public void tickRotation() {
        if (this.rotationEnabled) {
            this.base.setRotationZ((this.base.getRotationZ() + 2) % 2048);
        }
    }

    @Override
    public void onButtonClicked(ScriptEvent scriptEvent) {
        switch (scriptEvent.getOp()) {
            case 2: {
                this.rotationEnabled = !this.rotationEnabled;
                break;
            }
            case 3: {
                this.base.setRotationZ(0);
            }
        }
    }
}

