/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.ui;

import io.hydrox.transmog.ui.CustomWidget;
import io.hydrox.transmog.ui.UIManager;
import net.runelite.api.widgets.Widget;

public class CustomWidgetNamePlate
extends CustomWidget {
    private static final int PLATE_CAP_LEFT = 1123;
    private static final int PLATE_CAP_RIGHT = 1125;
    private static final int PLATE_BACKGROUND_TILE = 1124;
    private static final int CAP_WIDTH = 4;
    private static final int HEIGHT = 14;
    private Widget capLeft;
    private Widget capRight;
    private Widget background;
    private Widget nameWidget;

    public CustomWidgetNamePlate(Widget parent, int width) {
        super(parent, "");
        this.width = width;
        this.height = 14;
    }

    @Override
    public void create() {
        this.capLeft = this.createSpriteWidget(4, 14);
        this.capLeft.setSpriteId(1123);
        this.capRight = this.createSpriteWidget(4, 14);
        this.capRight.setSpriteId(1125);
        this.background = this.createSpriteWidget(this.width - 8, 14);
        this.background.setSpriteId(1124);
        this.background.setSpriteTiling(true);
        this.nameWidget = this.createTextWidget("");
        this.nameWidget.setOriginalWidth(this.width);
        this.nameWidget.setOriginalHeight(14);
        this.nameWidget.setXTextAlignment(1);
        this.nameWidget.setYTextAlignment(1);
        this.nameWidget.setFontId(494);
        this.nameWidget.setTextColor(0xFFFF00);
    }

    public void setText(String text) {
        if (UIManager.FONT_METRICS.stringWidth(text) > this.width) {
            text = UIManager.cutStringToPxWidth(text, this.width, true);
        }
        this.nameWidget.setText(text);
    }

    @Override
    public void layout(int x, int y) {
        super.layout(x, y);
        CustomWidgetNamePlate.layoutWidget(this.capLeft, x, y);
        CustomWidgetNamePlate.layoutWidget(this.capRight, x + this.width - 4, y);
        CustomWidgetNamePlate.layoutWidget(this.background, x + 4, y);
        CustomWidgetNamePlate.layoutWidget(this.nameWidget, x, y);
        this.parent.revalidate();
    }
}

