/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.ui;

import io.hydrox.transmog.ui.CustomWidget;
import io.hydrox.transmog.ui.InteractibleWidget;
import net.runelite.api.ScriptEvent;
import net.runelite.api.widgets.Widget;

public class CustomWidgetConfigButton
extends CustomWidget
implements InteractibleWidget {
    static final int BORDER_SIZE = 9;
    private static final int LARGE_ICON_SIZE = 32;
    private static final int SMALL_ICON_SIZE = 20;
    private static final int COG_SMALL = 2410;
    private Widget overlay;
    private Widget topLeftBrace;
    private Widget topRightBrace;
    private Widget bottomLeftBrace;
    private Widget bottomRightBrace;
    private Widget leftSide;
    private Widget topSide;
    private Widget rightSide;
    private Widget bottomSide;
    private Widget itemIcon;
    private Widget largeIcon;
    private Widget smallIcon;
    protected final InteractibleWidget.WidgetIntCallback callback;

    public CustomWidgetConfigButton(Widget parent, String name, InteractibleWidget.WidgetIntCallback callback) {
        super(parent, name);
        this.callback = callback;
    }

    @Override
    public void create() {
        this.topLeftBrace = this.createSpriteWidget(9, 9);
        this.topRightBrace = this.createSpriteWidget(9, 9);
        this.bottomLeftBrace = this.createSpriteWidget(9, 9);
        this.bottomRightBrace = this.createSpriteWidget(9, 9);
        this.leftSide = this.createSpriteWidget(9, this.height - 18);
        this.topSide = this.createSpriteWidget(this.width - 18, 9);
        this.rightSide = this.createSpriteWidget(9, this.height - 18);
        this.bottomSide = this.createSpriteWidget(this.width - 18, 9);
        this.onLeave();
        this.largeIcon = this.createSpriteWidget(32, 32);
        this.largeIcon.setSpriteId(2410);
        this.itemIcon = this.createSpriteWidget(36, 32);
        this.itemIcon.setItemQuantity(-1);
        this.itemIcon.setItemQuantityMode(2);
        this.itemIcon.setBorderType(1);
        this.smallIcon = this.createSpriteWidget(20, 20);
        this.smallIcon.setSpriteId(2410);
        this.smallIcon.setHidden(true);
        this.overlay = this.createSpriteWidget(this.width, this.height);
        this.overlay.setOnOpListener(new Object[]{this::onButtonClicked});
        this.overlay.setOnMouseRepeatListener(new Object[]{e -> this.onHover()});
        this.overlay.setOnMouseLeaveListener(new Object[]{e -> this.onLeave()});
        this.overlay.setHasListener(true);
    }

    public void addOption(int index, String action) {
        this.overlay.setAction(index, action);
    }

    public void setItemIcon(int itemID) {
        this.itemIcon.setItemId(itemID);
        this.largeIcon.setHidden(itemID != -1);
        this.smallIcon.setHidden(itemID == -1);
        if (itemID == -1) {
            this.addOption(2, "Set Icon");
            this.addOption(3, null);
        } else {
            this.addOption(2, "Change Icon");
            this.addOption(3, "Remove Icon");
        }
    }

    private void onHover() {
        this.topLeftBrace.setSpriteId(921);
        this.topRightBrace.setSpriteId(922);
        this.bottomLeftBrace.setSpriteId(923);
        this.bottomRightBrace.setSpriteId(924);
        this.leftSide.setSpriteId(925);
        this.topSide.setSpriteId(926);
        this.rightSide.setSpriteId(927);
        this.bottomSide.setSpriteId(928);
    }

    private void onLeave() {
        this.topLeftBrace.setSpriteId(913);
        this.topRightBrace.setSpriteId(914);
        this.bottomLeftBrace.setSpriteId(915);
        this.bottomRightBrace.setSpriteId(916);
        this.leftSide.setSpriteId(917);
        this.topSide.setSpriteId(918);
        this.rightSide.setSpriteId(919);
        this.bottomSide.setSpriteId(920);
    }

    @Override
    public void layout(int x, int y) {
        CustomWidgetConfigButton.layoutWidget(this.overlay, x, y);
        CustomWidgetConfigButton.layoutWidget(this.largeIcon, x + 3, y + 3);
        CustomWidgetConfigButton.layoutWidget(this.smallIcon, x + this.width - 20 - 2, y + this.height - 20 - 2);
        CustomWidgetConfigButton.layoutWidget(this.itemIcon, x + 4, y + 3);
        CustomWidgetConfigButton.layoutWidget(this.topLeftBrace, x, y);
        CustomWidgetConfigButton.layoutWidget(this.topRightBrace, x + this.width - 9, y);
        CustomWidgetConfigButton.layoutWidget(this.bottomLeftBrace, x, y + this.height - 9);
        CustomWidgetConfigButton.layoutWidget(this.bottomRightBrace, x + this.width - 9, y + this.height - 9);
        CustomWidgetConfigButton.layoutWidget(this.leftSide, x, y + 9);
        CustomWidgetConfigButton.layoutWidget(this.topSide, x + 9, y);
        CustomWidgetConfigButton.layoutWidget(this.rightSide, x + this.width - 9, y + 9);
        CustomWidgetConfigButton.layoutWidget(this.bottomSide, x + 9, y + this.height - 9);
        super.layout(x, y);
    }

    @Override
    public void onButtonClicked(ScriptEvent scriptEvent) {
        this.callback.run(scriptEvent.getOp() - 1);
    }
}

