/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.ui;

import io.hydrox.transmog.ui.CustomSprites;
import io.hydrox.transmog.ui.CustomWidget;
import java.awt.Color;
import net.runelite.api.widgets.JavaScriptCallback;
import net.runelite.api.widgets.Widget;

public class CustomWidgetBlockerBox
extends CustomWidget {
    private static final int TOP_LEFT_CORNER_SIZE = 31;
    private static final int BOTTOM_RIGHT_CORNER_SIZE = 51;
    private static final int OPACITY = 120;
    private Widget leftBar;
    private Widget middleBar;
    private Widget rightBar;
    private Widget cornerBlocker;
    private Widget textStage1;
    private Widget textStage2;
    private Widget arrow;

    public CustomWidgetBlockerBox(Widget parent, String name) {
        super(parent, name);
    }

    public void setHidden(boolean state) {
        this.leftBar.setHidden(state);
        this.middleBar.setHidden(state);
        this.rightBar.setHidden(state);
        this.cornerBlocker.setHidden(state);
        this.textStage1.setHidden(state);
        this.textStage2.setHidden(state);
        this.arrow.setHidden(state);
    }

    public void setTutorialState(int state) {
        switch (state) {
            case 1: {
                this.textStage1.setHidden(false);
                this.textStage2.setHidden(true);
                this.arrow.setHidden(true);
                this.cornerBlocker.setHidden(false);
                return;
            }
            case 2: {
                this.textStage1.setHidden(true);
                this.textStage2.setHidden(false);
                this.arrow.setHidden(false);
                this.cornerBlocker.setHidden(true);
            }
        }
    }

    @Override
    public void layout(int x, int y) {
        super.layout(x, y);
        CustomWidgetBlockerBox.layoutWidget(this.leftBar, x, y + 31);
        CustomWidgetBlockerBox.layoutWidget(this.middleBar, x + 31, y);
        CustomWidgetBlockerBox.layoutWidget(this.rightBar, x + this.width - 51, y);
        CustomWidgetBlockerBox.layoutWidget(this.cornerBlocker, x + this.width - 51, y + this.height - 51);
        CustomWidgetBlockerBox.layoutWidget(this.textStage1, x + 10, y);
        CustomWidgetBlockerBox.layoutWidget(this.textStage2, x + 10, y);
        CustomWidgetBlockerBox.layoutWidget(this.arrow, x + this.width - 100, y + this.height - 100);
        this.parent.revalidate();
    }

    @Override
    public void create() {
        JavaScriptCallback empty = ev -> {};
        this.leftBar = this.createRectangleWidget(31, this.height - 31);
        this.leftBar.setFilled(true);
        this.leftBar.setOpacity(120);
        this.leftBar.setHasListener(true);
        this.leftBar.setNoClickThrough(true);
        this.leftBar.setOnOpListener(new Object[]{empty});
        this.middleBar = this.createRectangleWidget(this.width - 82, this.height);
        this.middleBar.setFilled(true);
        this.middleBar.setOpacity(120);
        this.middleBar.setHasListener(true);
        this.middleBar.setNoClickThrough(true);
        this.middleBar.setOnOpListener(new Object[]{empty});
        this.rightBar = this.createRectangleWidget(51, this.height - 51);
        this.rightBar.setFilled(true);
        this.rightBar.setOpacity(120);
        this.rightBar.setHasListener(true);
        this.rightBar.setNoClickThrough(true);
        this.rightBar.setOnOpListener(new Object[]{empty});
        this.cornerBlocker = this.createRectangleWidget(51, 51);
        this.cornerBlocker.setFilled(true);
        this.cornerBlocker.setOpacity(120);
        this.cornerBlocker.setHasListener(true);
        this.cornerBlocker.setNoClickThrough(true);
        this.cornerBlocker.setOnOpListener(new Object[]{empty});
        this.textStage1 = this.createTextWidget("The plugin needs to know your base outfit. First, remove all of your equipment.");
        this.textStage1.setXTextAlignment(1);
        this.textStage1.setYTextAlignment(1);
        this.textStage1.setOriginalWidth(this.width - 20);
        this.textStage1.setOriginalHeight(this.height);
        this.textStage1.setTextColor(CustomWidgetBlockerBox.fromRGB(Color.YELLOW));
        this.textStage1.setFontId(495);
        this.textStage2 = this.createTextWidget("Now click the button in the corner to provide a default state.");
        this.textStage2.setXTextAlignment(1);
        this.textStage2.setYTextAlignment(1);
        this.textStage2.setOriginalWidth(this.width - 20);
        this.textStage2.setOriginalHeight(this.height);
        this.textStage2.setTextColor(CustomWidgetBlockerBox.fromRGB(Color.YELLOW));
        this.textStage2.setFontId(495);
        this.arrow = this.createSpriteWidget(48, 48);
        this.arrow.setSpriteId(CustomSprites.TUTORIAL_ARROW.getSpriteId());
    }

    private Widget createRectangleWidget(int width, int height) {
        Widget w = this.parent.createChild(-1, 3);
        w.setOriginalHeight(height);
        w.setOriginalWidth(width);
        return w;
    }
}

