/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.ui;

import io.hydrox.transmog.ui.CustomWidgetWithIcon;
import io.hydrox.transmog.ui.InteractibleWidget;
import net.runelite.api.ScriptEvent;
import net.runelite.api.widgets.Widget;

public class CustomWidgetActionButton
extends CustomWidgetWithIcon
implements InteractibleWidget {
    static final int BORDER_SIZE = 9;
    private Widget overlay;
    private Widget topLeftBrace;
    private Widget topRightBrace;
    private Widget bottomLeftBrace;
    private Widget bottomRightBrace;
    private Widget leftSide;
    private Widget topSide;
    private Widget rightSide;
    private Widget bottomSide;
    protected final InteractibleWidget.WidgetIntCallback callback;

    public CustomWidgetActionButton(Widget parent, String name, int iconSprite, InteractibleWidget.WidgetIntCallback callback) {
        super(parent, name, iconSprite);
        this.callback = callback;
    }

    @Override
    public void create() {
        this.topLeftBrace = this.createSpriteWidget(9, 9);
        this.topRightBrace = this.createSpriteWidget(9, 9);
        this.bottomLeftBrace = this.createSpriteWidget(9, 9);
        this.bottomRightBrace = this.createSpriteWidget(9, 9);
        this.leftSide = this.createSpriteWidget(9, this.height - 18);
        this.topSide = this.createSpriteWidget(this.width - 18, 9);
        this.rightSide = this.createSpriteWidget(9, this.height - 18);
        this.bottomSide = this.createSpriteWidget(this.width - 18, 9);
        this.onLeave();
        this.icon = this.createSpriteWidget(this.iconWidth, this.iconHeight);
        this.icon.setSpriteId(this.iconSpriteID);
        this.overlay = this.createSpriteWidget(this.width, this.height);
        this.overlay.setOnOpListener(new Object[]{this::onButtonClicked});
        this.overlay.setOnMouseRepeatListener(new Object[]{e -> this.onHover()});
        this.overlay.setOnMouseLeaveListener(new Object[]{e -> this.onLeave()});
        this.overlay.setHasListener(true);
    }

    public void addOption(int index, String action) {
        this.overlay.setAction(index, action);
    }

    public void setIconSprite(int spriteID) {
        this.icon.setSpriteId(spriteID);
    }

    private void onHover() {
        this.topLeftBrace.setSpriteId(921);
        this.topRightBrace.setSpriteId(922);
        this.bottomLeftBrace.setSpriteId(923);
        this.bottomRightBrace.setSpriteId(924);
        this.leftSide.setSpriteId(925);
        this.topSide.setSpriteId(926);
        this.rightSide.setSpriteId(927);
        this.bottomSide.setSpriteId(928);
    }

    private void onLeave() {
        this.topLeftBrace.setSpriteId(913);
        this.topRightBrace.setSpriteId(914);
        this.bottomLeftBrace.setSpriteId(915);
        this.bottomRightBrace.setSpriteId(916);
        this.leftSide.setSpriteId(917);
        this.topSide.setSpriteId(918);
        this.rightSide.setSpriteId(919);
        this.bottomSide.setSpriteId(920);
    }

    @Override
    public void layout(int x, int y) {
        CustomWidgetActionButton.layoutWidget(this.overlay, x, y);
        CustomWidgetActionButton.layoutWidget(this.topLeftBrace, x, y);
        CustomWidgetActionButton.layoutWidget(this.topRightBrace, x + this.width - 9, y);
        CustomWidgetActionButton.layoutWidget(this.bottomLeftBrace, x, y + this.height - 9);
        CustomWidgetActionButton.layoutWidget(this.bottomRightBrace, x + this.width - 9, y + this.height - 9);
        CustomWidgetActionButton.layoutWidget(this.leftSide, x, y + 9);
        CustomWidgetActionButton.layoutWidget(this.topSide, x + 9, y);
        CustomWidgetActionButton.layoutWidget(this.rightSide, x + this.width - 9, y + 9);
        CustomWidgetActionButton.layoutWidget(this.bottomSide, x + 9, y + this.height - 9);
        super.layout(x, y);
    }

    @Override
    public void onButtonClicked(ScriptEvent scriptEvent) {
        this.callback.run(scriptEvent.getOp() - 1);
    }
}

