/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.ui;

import java.awt.Color;
import net.runelite.api.widgets.Widget;

public abstract class CustomWidget {
    protected final Widget parent;
    private final String name;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected Widget base;

    public CustomWidget(Widget parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void layout(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public abstract void create();

    protected Widget createSpriteWidget(int width, int height) {
        Widget w = this.parent.createChild(-1, 5);
        w.setOriginalWidth(width);
        w.setOriginalHeight(height);
        w.setName("<col=ff981f>" + this.name);
        return w;
    }

    protected Widget createModelWidget(int width, int height) {
        Widget w = this.parent.createChild(-1, 6);
        w.setOriginalWidth(width);
        w.setOriginalHeight(height);
        w.setName("<col=ff981f>" + this.name);
        return w;
    }

    protected Widget createTextWidget(String text) {
        Widget w = this.parent.createChild(-1, 4);
        w.setText(text);
        w.setTextShadowed(true);
        return w;
    }

    protected static void layoutWidget(Widget w, int x, int y) {
        w.setOriginalX(x);
        w.setOriginalY(y);
        w.revalidate();
    }

    protected static int fromRGB(Color c) {
        return CustomWidget.fromRGB(c.getRed(), c.getGreen(), c.getBlue());
    }

    protected static int fromRGB(int r, int g, int b) {
        return (r << 16) + (g << 8) + b;
    }
}

