/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.ui;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.hydrox.transmog.Mapping;
import io.hydrox.transmog.MappingMapping;
import io.hydrox.transmog.TransmogSlot;
import io.hydrox.transmog.TransmogrificationPlugin;
import io.hydrox.transmog.ui.CustomSearch;
import java.util.function.Consumer;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.chatbox.ChatboxPanelManager;

@Singleton
public class CustomSpriteSearch
extends CustomSearch {
    private final TransmogrificationPlugin plugin;
    protected Consumer<Mapping> onItemSelected;
    private Mapping[] source;
    private TransmogSlot slot;

    @Inject
    private CustomSpriteSearch(ChatboxPanelManager chatboxPanelManager, ClientThread clientThread, Client client, TransmogrificationPlugin plugin) {
        super(chatboxPanelManager, clientThread, client);
        this.plugin = plugin;
    }

    @Override
    protected void createContents(Widget container) {
        MappingMapping mappingMapping = MappingMapping.fromSlot(this.slot);
        int x = 6;
        int y = 18;
        int idx = 0;
        for (int i = this.page * 24; i < (this.page + 1) * 24 && i < this.results.size(); ++i) {
            Mapping mapping = (Mapping)this.results.get(i);
            Widget model = container.createChild(-1, 6);
            model.setXPositionMode(0);
            model.setYPositionMode(0);
            model.setOriginalX(x);
            model.setOriginalY(y + 32 + mappingMapping.getYOffset());
            model.setOriginalHeight(32);
            model.setOriginalWidth(36);
            model.setModelId(mapping.modelId());
            model.setModelZoom(mappingMapping.getModelZoom());
            model.setRotationZ(150);
            Widget clickBox = container.createChild(-1, 3);
            clickBox.setOpacity(255);
            clickBox.setXPositionMode(0);
            clickBox.setYPositionMode(0);
            clickBox.setOriginalX(x);
            clickBox.setOriginalY(y + 32);
            clickBox.setOriginalHeight(32);
            clickBox.setOriginalWidth(36);
            clickBox.setName("<col=ff981f>" + mapping.prettyName());
            clickBox.setAction(0, this.tooltipText);
            clickBox.setHasListener(true);
            if (this.index == idx) {
                model.setOpacity(128);
            } else {
                clickBox.setOnMouseOverListener(new Object[]{ev -> model.setOpacity(128)});
                clickBox.setOnMouseLeaveListener(new Object[]{ev -> model.setOpacity(0)});
            }
            clickBox.setOnOpListener(new Object[]{ev -> {
                if (this.hasCallback()) {
                    this.runCallback(mapping);
                }
                this.chatboxPanelManager.close();
            }});
            if ((x += 42) + 36 >= container.getWidth()) {
                y += 38;
                x = 6;
            }
            model.revalidate();
            clickBox.revalidate();
            ++idx;
        }
    }

    @Override
    protected void filterResults() {
        this.results.clear();
        this.index = -1;
        String search = this.getValue().toLowerCase();
        for (Mapping mapping : this.source) {
            if (!mapping.prettyName().toLowerCase().contains(search) || mapping.bodyKit() != this.plugin.getBodyKit()) continue;
            this.results.add(mapping);
        }
    }

    @Override
    protected void runCallback(Object o) {
        this.onItemSelected.accept((Mapping)o);
    }

    @Override
    protected boolean hasCallback() {
        return this.onItemSelected != null;
    }

    public void setOnItemSelected(Consumer<Mapping> onItemSelected) {
        this.onItemSelected = onItemSelected;
    }

    public void setSource(Mapping[] source) {
        this.source = source;
    }

    public void setSlot(TransmogSlot slot) {
        this.slot = slot;
    }
}

