/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.ui;

import com.google.common.primitives.Ints;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.game.chatbox.ChatboxTextInput;

public abstract class CustomSearch
extends ChatboxTextInput {
    protected static final int ICON_HEIGHT = 32;
    protected static final int ICON_WIDTH = 36;
    protected static final int PADDING = 6;
    protected static final int MAX_RESULTS = 24;
    protected static final int FONT_SIZE = 16;
    protected static final int HOVERED_OPACITY = 128;
    protected final ChatboxPanelManager chatboxPanelManager;
    protected final Client client;
    protected List<Object> results = new ArrayList<Object>();
    protected String tooltipText;
    protected int index = -1;
    protected int page = 0;

    protected CustomSearch(ChatboxPanelManager chatboxPanelManager, ClientThread clientThread, Client client) {
        super(chatboxPanelManager, clientThread);
        this.chatboxPanelManager = chatboxPanelManager;
        this.client = client;
        this.lines(1);
        this.onChanged(searchString -> clientThread.invokeLater(() -> {
            this.filterResults();
            this.update();
        }));
    }

    protected void open() {
        this.filterResults();
        super.open();
    }

    protected void update() {
        Widget container = this.chatboxPanelManager.getContainerWidget();
        container.deleteAllChildren();
        Widget promptWidget = container.createChild(-1, 4);
        promptWidget.setText(this.getPrompt());
        promptWidget.setTextColor(0x800000);
        promptWidget.setFontId(this.getFontID());
        promptWidget.setOriginalX(0);
        promptWidget.setOriginalY(5);
        promptWidget.setXPositionMode(1);
        promptWidget.setYPositionMode(0);
        promptWidget.setOriginalHeight(16);
        promptWidget.setXTextAlignment(1);
        promptWidget.setYTextAlignment(1);
        promptWidget.setWidthMode(1);
        promptWidget.revalidate();
        this.buildEdit(0, 21, container.getWidth(), 16);
        Widget separator = container.createChild(-1, 9);
        separator.setOriginalX(0);
        separator.setOriginalY(40);
        separator.setXPositionMode(1);
        separator.setYPositionMode(0);
        separator.setOriginalHeight(0);
        separator.setOriginalWidth(16);
        separator.setWidthMode(1);
        separator.setTextColor(0x666666);
        separator.revalidate();
        int lastPage = this.results.size() / 24;
        if (this.page > lastPage) {
            this.page = lastPage;
        }
        Widget pageBack = container.createChild(-1, 5);
        pageBack.setHidden(this.page == 0 || this.results.isEmpty());
        pageBack.setAction(0, "Previous Page");
        pageBack.setSpriteId(425);
        pageBack.setOriginalWidth(20);
        pageBack.setOriginalHeight(20);
        pageBack.setOriginalX(container.getWidth() - 90);
        pageBack.setOriginalY(0);
        pageBack.setOnOpListener(new Object[]{e -> {
            this.page = this.page <= 0 ? 0 : this.page - 1;
            this.update();
        }});
        pageBack.setHasListener(true);
        pageBack.revalidate();
        Widget pageNum = container.createChild(-1, 4);
        pageNum.setHidden(this.isSearchOnLastPage() && this.page == 0 || this.results.isEmpty());
        pageNum.setFontId(495);
        pageNum.setText("" + (this.page + 1));
        pageNum.setOriginalWidth(20);
        pageNum.setOriginalHeight(20);
        pageNum.setOriginalX(container.getWidth() - 70);
        pageNum.setOriginalY(2);
        pageNum.setXTextAlignment(1);
        pageNum.setYTextAlignment(1);
        pageNum.revalidate();
        Widget pageNext = container.createChild(-1, 5);
        pageNext.setHidden(this.isSearchOnLastPage() || this.results.isEmpty());
        pageNext.setAction(0, "Next Page");
        pageNext.setSpriteId(426);
        pageNext.setOriginalWidth(20);
        pageNext.setOriginalHeight(20);
        pageNext.setOriginalX(container.getWidth() - 50);
        pageNext.setOriginalY(0);
        pageNext.setOnOpListener(new Object[]{e -> {
            this.page = this.isSearchOnLastPage() ? this.page : this.page + 1;
            this.update();
        }});
        pageNext.setHasListener(true);
        pageNext.revalidate();
        Widget exit = container.createChild(-1, 5);
        exit.setOriginalX(container.getWidth() - 20);
        exit.setOriginalY(0);
        exit.setOriginalWidth(20);
        exit.setOriginalHeight(20);
        exit.setSpriteId(1126);
        exit.setAction(0, "Close");
        exit.setOnOpListener(new Object[]{e -> this.chatboxPanelManager.close()});
        exit.setOnMouseRepeatListener(new Object[]{e -> exit.setSpriteId(1127)});
        exit.setOnMouseLeaveListener(new Object[]{e -> exit.setSpriteId(1126)});
        exit.setHasListener(true);
        exit.revalidate();
        this.createContents(container);
    }

    protected abstract void createContents(Widget var1);

    public void keyPressed(KeyEvent ev) {
        switch (ev.getKeyCode()) {
            case 10: {
                ev.consume();
                if (this.index <= -1) break;
                if (this.hasCallback()) {
                    this.runCallback(this.results.get(this.index));
                }
                this.chatboxPanelManager.close();
                break;
            }
            case 9: 
            case 39: {
                ev.consume();
                if (this.results.isEmpty()) break;
                ++this.index;
                if (this.index >= this.results.size()) {
                    this.index = 0;
                }
                this.clientThread.invokeLater(this::update);
                break;
            }
            case 37: {
                ev.consume();
                if (this.results.isEmpty()) break;
                --this.index;
                if (this.index < 0) {
                    this.index = this.results.size() - 1;
                }
                this.clientThread.invokeLater(this::update);
                break;
            }
            case 38: {
                ev.consume();
                if (this.results.size() < 12) break;
                this.index -= 12;
                if (this.index < 0) {
                    this.index = this.results.size() == 24 ? (this.index += this.results.size()) : (this.index += 24);
                    this.index = Ints.constrainToRange((int)this.index, (int)0, (int)(this.results.size() - 1));
                }
                this.clientThread.invokeLater(this::update);
                break;
            }
            case 40: {
                ev.consume();
                if (this.results.size() < 12) break;
                this.index += 12;
                if (this.index >= 24) {
                    this.index = this.results.size() == 24 ? (this.index -= this.results.size()) : (this.index -= 24);
                    this.index = Ints.constrainToRange((int)this.index, (int)0, (int)(this.results.size() - 1));
                }
                this.clientThread.invokeLater(this::update);
                break;
            }
            default: {
                super.keyPressed(ev);
            }
        }
    }

    protected void close() {
        this.value("");
        this.results.clear();
        this.index = -1;
        this.page = 0;
        super.close();
    }

    @Deprecated
    public ChatboxTextInput onDone(Consumer<String> onDone) {
        throw new UnsupportedOperationException();
    }

    protected abstract void filterResults();

    protected abstract void runCallback(Object var1);

    protected abstract boolean hasCallback();

    public void setTooltipText(String text) {
        this.tooltipText = text;
    }

    public void setPrompt(String prompt) {
        super.prompt(prompt);
    }

    private boolean isSearchOnLastPage() {
        return (this.page + 1) * 24 >= this.results.size();
    }
}

