/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.ui;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.hydrox.transmog.StupidItems;
import io.hydrox.transmog.TransmogSlot;
import io.hydrox.transmog.ui.CustomSearch;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.http.api.item.ItemEquipmentStats;
import net.runelite.http.api.item.ItemStats;

@Singleton
public class CustomItemSearch
extends CustomSearch {
    private static final Set<Integer> IGNORED_ITEMS = Sets.newHashSet((Object[])new Integer[]{22664, 22665, 22666});
    private TransmogSlot slot;
    private final ItemManager itemManager;
    protected BiConsumer<Integer, String> onItemSelected;

    @Inject
    protected CustomItemSearch(ChatboxPanelManager chatboxPanelManager, ClientThread clientThread, ItemManager itemManager, Client client) {
        super(chatboxPanelManager, clientThread, client);
        this.itemManager = itemManager;
    }

    @Override
    protected void createContents(Widget container) {
        int x = 6;
        int y = 18;
        int idx = 0;
        for (int i = this.page * 24; i < (this.page + 1) * 24 && i < this.results.size(); ++i) {
            ItemComposition itemComposition = (ItemComposition)this.results.get(i);
            Widget item = container.createChild(-1, 5);
            item.setXPositionMode(0);
            item.setYPositionMode(0);
            item.setOriginalX(x);
            item.setOriginalY(y + 32);
            item.setOriginalHeight(32);
            item.setOriginalWidth(36);
            item.setName("<col=ff981f>" + itemComposition.getName());
            item.setItemId(itemComposition.getId());
            item.setItemQuantity(10000);
            item.setItemQuantityMode(0);
            item.setBorderType(1);
            item.setAction(0, this.tooltipText);
            item.setHasListener(true);
            if (this.index == idx) {
                item.setOpacity(128);
            } else {
                item.setOnMouseOverListener(new Object[]{ev -> item.setOpacity(128)});
                item.setOnMouseLeaveListener(new Object[]{ev -> item.setOpacity(0)});
            }
            item.setOnOpListener(new Object[]{ev -> {
                if (this.hasCallback()) {
                    this.runCallback(itemComposition);
                }
                this.chatboxPanelManager.close();
            }});
            if ((x += 42) + 36 >= container.getWidth()) {
                y += 38;
                x = 6;
            }
            item.revalidate();
            ++idx;
        }
    }

    @Override
    protected void filterResults() {
        this.results.clear();
        this.index = -1;
        String search = this.getValue().toLowerCase();
        HashSet<ItemIcon> itemIcons = new HashSet<ItemIcon>();
        for (int i = 0; i < this.client.getItemCount(); ++i) {
            ItemIcon itemIcon;
            ItemComposition itemComposition = this.itemManager.getItemComposition(this.itemManager.canonicalize(i));
            ItemStats itemStats = this.itemManager.getItemStats(itemComposition.getId(), false);
            if (itemStats == null || !itemStats.isEquipable()) continue;
            ItemEquipmentStats stats = itemStats.getEquipment();
            String name = itemComposition.getName().toLowerCase();
            if (stats.getSlot() != this.slot.getKitIndex() || !name.contains(search) || this.results.contains(itemComposition) || name.equals("null") || IGNORED_ITEMS.contains(i) || itemIcons.contains(itemIcon = new ItemIcon(itemComposition.getInventoryModel(), itemComposition.getColorToReplaceWith(), itemComposition.getTextureToReplaceWith()))) continue;
            itemIcons.add(itemIcon);
            this.results.add(itemComposition);
        }
    }

    @Override
    protected void runCallback(Object o) {
        ItemComposition ic = (ItemComposition)o;
        this.onItemSelected.accept(StupidItems.convertId(ic.getId()), ic.getName());
    }

    @Override
    protected boolean hasCallback() {
        return this.onItemSelected != null;
    }

    public void setSlot(TransmogSlot slot) {
        this.slot = slot;
    }

    public void setOnItemSelected(BiConsumer<Integer, String> onItemSelected) {
        this.onItemSelected = onItemSelected;
    }

    private static final class ItemIcon {
        private final int modelId;
        private final short[] colorsToReplace;
        private final short[] texturesToReplace;

        public ItemIcon(int modelId, short[] colorsToReplace, short[] texturesToReplace) {
            this.modelId = modelId;
            this.colorsToReplace = colorsToReplace;
            this.texturesToReplace = texturesToReplace;
        }

        public int getModelId() {
            return this.modelId;
        }

        public short[] getColorsToReplace() {
            return this.colorsToReplace;
        }

        public short[] getTexturesToReplace() {
            return this.texturesToReplace;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemIcon)) {
                return false;
            }
            ItemIcon other = (ItemIcon)o;
            if (this.getModelId() != other.getModelId()) {
                return false;
            }
            if (!Arrays.equals(this.getColorsToReplace(), other.getColorsToReplace())) {
                return false;
            }
            return Arrays.equals(this.getTexturesToReplace(), other.getTexturesToReplace());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getModelId();
            result = result * 59 + Arrays.hashCode(this.getColorsToReplace());
            result = result * 59 + Arrays.hashCode(this.getTexturesToReplace());
            return result;
        }

        public String toString() {
            return "CustomItemSearch.ItemIcon(modelId=" + this.getModelId() + ", colorsToReplace=" + Arrays.toString(this.getColorsToReplace()) + ", texturesToReplace=" + Arrays.toString(this.getTexturesToReplace()) + ")";
        }
    }
}

