/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog.config;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.hydrox.transmog.TransmogPreset;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.runelite.client.config.ConfigManager;

@Singleton
public class TransmogrificationConfigManager {
    private static final String CONFIG_GROUP = "transmog";
    private static final String CONFIG_DEFAULT = "default";
    private static final String CONFIG_OVERRIDE = "override";
    private static final String CONFIG_PRESET = "preset_";
    private static final String CONFIG_LAST_PRESET_IDX = "lastIndex";
    private static final String CONFIG_TRANSMOG_ACTIVE = "transmogActive";
    private static final String CONFIG_CURRENT_PRESET = "currentPreset";
    private static final String CONFIG_TRANSMIT_TO_PARTY = "transmitToParty";
    private final ConfigManager configManager;

    @Inject
    TransmogrificationConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public boolean transmogActive() {
        return Optional.ofNullable((Boolean)this.configManager.getRSProfileConfiguration(CONFIG_GROUP, CONFIG_TRANSMOG_ACTIVE, Boolean.class)).orElse(false);
    }

    public void transmogActive(boolean value) {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP, CONFIG_TRANSMOG_ACTIVE, (Object)value);
    }

    public boolean transmitToParty() {
        return Optional.ofNullable((Boolean)this.configManager.getRSProfileConfiguration(CONFIG_GROUP, CONFIG_TRANSMIT_TO_PARTY, Boolean.class)).orElse(false);
    }

    public void transmitToParty(boolean value) {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP, CONFIG_TRANSMIT_TO_PARTY, (Object)value);
    }

    public int currentPreset() {
        return Optional.ofNullable((Integer)this.configManager.getRSProfileConfiguration(CONFIG_GROUP, CONFIG_CURRENT_PRESET, Integer.class)).orElse(this.lastIndex());
    }

    public void currentPreset(int value) {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP, CONFIG_CURRENT_PRESET, (Object)value);
    }

    public int lastIndex() {
        return Optional.ofNullable((Integer)this.configManager.getRSProfileConfiguration(CONFIG_GROUP, CONFIG_LAST_PRESET_IDX, Integer.class)).orElse(0);
    }

    public void lastIndex(int value) {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP, CONFIG_LAST_PRESET_IDX, (Object)value);
    }

    public String getPresetData(int index) {
        return this.configManager.getRSProfileConfiguration(CONFIG_GROUP, "override.preset_" + index);
    }

    public void savePreset(TransmogPreset preset) {
        String key = "override.preset_" + preset.getId();
        String value = preset.toConfig();
        if (value != null) {
            this.configManager.setRSProfileConfiguration(CONFIG_GROUP, key, (Object)value);
        }
    }

    public void savePreset(int presetID, TransmogPreset preset) {
        String value;
        String key = "override.preset_" + presetID;
        if (preset != null && (value = preset.toConfig()) != null) {
            this.configManager.setRSProfileConfiguration(CONFIG_GROUP, key, (Object)value);
            return;
        }
        this.configManager.unsetRSProfileConfiguration(CONFIG_GROUP, key);
    }

    public String getDefaultStateData() {
        return this.configManager.getRSProfileConfiguration(CONFIG_GROUP, CONFIG_DEFAULT);
    }

    public void saveDefaultState(int[] state) {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP, CONFIG_DEFAULT, (Object)Arrays.stream(state).mapToObj(String::valueOf).collect(Collectors.joining(",")));
    }
}

