/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog;

import com.google.inject.Inject;
import io.hydrox.transmog.BodyKit;
import io.hydrox.transmog.TransmogPartyManager;
import io.hydrox.transmog.TransmogUpdateMessage;
import io.hydrox.transmog.TransmogrificationManager;
import io.hydrox.transmog.config.TransmogrificationConfigManager;
import io.hydrox.transmog.ui.CustomSprites;
import io.hydrox.transmog.ui.UIManager;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import javax.inject.Provider;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuShouldLeftClick;
import net.runelite.api.events.PlayerChanged;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.api.events.ResizeableChanged;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.PartyChanged;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.game.SpriteOverride;
import net.runelite.client.input.MouseManager;
import net.runelite.client.input.MouseWheelListener;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.events.UserJoin;
import net.runelite.client.party.events.UserPart;
import net.runelite.client.party.messages.UserSync;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.party.PartyPlugin;
import net.runelite.client.plugins.party.messages.StatusUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Transmogrification", description="Wear the armour you want, no matter what you're doing.", tags={"transmog", "transmogrification", "fashion", "armour", "armor", "equipment"})
@PluginDependency(value=PartyPlugin.class)
public class TransmogrificationPlugin
extends Plugin
implements MouseWheelListener {
    private static final Logger log = LoggerFactory.getLogger(TransmogrificationPlugin.class);
    private static final String FORCE_RIGHT_CLICK_MENU_FLAG = "<col=ff981f><col=004356>";
    private static final int SCRIPT_ID_EQUIPMENT_TAB_CREATED = 914;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private TransmogrificationConfigManager config;
    @Inject
    private TransmogrificationManager transmogManager;
    @Inject
    private TransmogPartyManager partyManager;
    @Inject
    private WSClient wsClient;
    @Inject
    private Provider<UIManager> uiManagerProvider;
    private UIManager uiManager;
    private int lastWorld = 0;
    private boolean forceRightClickFlag;
    private boolean firstContainerChangeFlag;
    private final Queue<Runnable> nextFrameRunnerQueue = new ArrayDeque<Runnable>();

    public void startUp() {
        if (this.uiManager == null) {
            this.uiManager = this.getUIManager();
        }
        this.wsClient.registerMessage(TransmogUpdateMessage.class);
        this.spriteManager.addSpriteOverrides((SpriteOverride[])CustomSprites.values());
        this.mouseManager.registerMouseWheelListener((MouseWheelListener)this);
        this.firstContainerChangeFlag = true;
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.nextFrameRunnerQueue.add(() -> {
                this.lastWorld = this.client.getWorld();
                this.transmogManager.saveCurrent();
                this.transmogManager.loadData();
                this.transmogManager.updateTransmog();
                this.uiManager.createTab(this.uiManager.getEquipmentOverlay());
                this.updatePvpState();
                this.updateEquipmentState();
            });
        }
    }

    public void shutDown() {
        this.spriteManager.removeSpriteOverrides((SpriteOverride[])CustomSprites.values());
        this.mouseManager.unregisterMouseWheelListener((MouseWheelListener)this);
        this.lastWorld = 0;
        this.clientThread.invoke(() -> {
            this.transmogManager.shutDown();
            this.uiManager.shutDown();
            this.partyManager.clearSharedPreset();
            this.wsClient.unregisterMessage(TransmogUpdateMessage.class);
        });
    }

    private void updatePvpState() {
        boolean newState;
        boolean bl = newState = this.client.getVarbitValue(8121) == 1;
        if (newState != this.transmogManager.isInPvpSituation()) {
            this.transmogManager.onPvpChanged(newState);
            this.uiManager.onPvpChanged(newState);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged e) {
        if (e.getGameState() == GameState.LOGGED_IN) {
            if (this.client.getWorld() != this.lastWorld) {
                this.transmogManager.setReady(false);
                this.nextFrameRunnerQueue.add(() -> {
                    this.lastWorld = this.client.getWorld();
                    this.transmogManager.loadData();
                    this.updateEquipmentState();
                    this.partyManager.shareCurrentPreset();
                });
            }
        } else if (e.getGameState() == GameState.LOGIN_SCREEN || e.getGameState() == GameState.HOPPING) {
            this.firstContainerChangeFlag = true;
            this.lastWorld = 0;
            this.uiManager.setUiCreated(false);
            this.transmogManager.clearUserStates();
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged e) {
        if (e.getContainerId() != InventoryID.EQUIPMENT.getId()) {
            return;
        }
        this.updateEquipmentState();
        if (!this.config.transmogActive()) {
            this.transmogManager.saveCurrent();
            return;
        }
        if (this.firstContainerChangeFlag) {
            this.firstContainerChangeFlag = false;
            return;
        }
        this.transmogManager.reapplyTransmog();
    }

    private void updateEquipmentState() {
        ItemContainer ic = this.client.getItemContainer(InventoryID.EQUIPMENT);
        boolean emptyEquipment = ic == null || Arrays.stream(ic.getItems()).distinct().noneMatch(i -> i != null && i.getId() != -1);
        this.transmogManager.setEmptyEquipment(emptyEquipment);
        this.uiManager.updateTutorial(emptyEquipment);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged e) {
        this.updatePvpState();
    }

    @Subscribe
    public void onGameTick(GameTick e) {
        this.partyManager.onGameTick();
        if (this.nextFrameRunnerQueue.size() > 0) {
            Runnable r = this.nextFrameRunnerQueue.poll();
            do {
                r.run();
            } while ((r = this.nextFrameRunnerQueue.poll()) != null);
        }
        if (this.client.getLocalPlayer() == null || !this.config.transmogActive()) {
            return;
        }
        int currentHash = Arrays.hashCode(this.client.getLocalPlayer().getPlayerComposition().getEquipmentIds());
        if (currentHash != this.transmogManager.getTransmogHash() && this.transmogManager.isDefaultStateSet()) {
            this.transmogManager.reapplyTransmog();
        }
    }

    @Subscribe
    public void onPlayerChanged(PlayerChanged e) {
        if (e.getPlayer() != this.client.getLocalPlayer()) {
            this.partyManager.onPlayerSpawned(e.getPlayer());
            return;
        }
        if (!this.transmogManager.isReady() || this.client.getLocalPlayer() == null || !this.config.transmogActive()) {
            return;
        }
        int currentHash = Arrays.hashCode(this.client.getLocalPlayer().getPlayerComposition().getEquipmentIds());
        if (currentHash != this.transmogManager.getTransmogHash()) {
            this.transmogManager.reapplyTransmog();
        }
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned e) {
        this.partyManager.onPlayerSpawned(e.getPlayer());
    }

    @Subscribe
    public void onPlayerDespawned(PlayerDespawned e) {
        this.partyManager.onPlayerDespawned(e.getPlayer());
    }

    @Subscribe
    public void onTransmogUpdateMessage(TransmogUpdateMessage e) {
        this.partyManager.onTransmogUpdateMessage(e);
    }

    @Subscribe
    public void onStatusUpdate(StatusUpdate e) {
        this.partyManager.onStatusUpdate();
    }

    @Subscribe
    public void onUserSync(UserSync e) {
        this.partyManager.onStatusUpdate();
    }

    @Subscribe
    public void onUserJoin(UserJoin e) {
        this.partyManager.shareCurrentPreset();
    }

    @Subscribe
    public void onUserPart(UserPart e) {
        this.partyManager.clearUser(e.getMemberId());
    }

    @Subscribe
    public void onPartyChanged(PartyChanged e) {
        Runnable runner = this.partyManager.onPartyChanged(e);
        if (runner != null) {
            this.nextFrameRunnerQueue.add(runner);
        }
    }

    @Subscribe
    public void onResizeableChanged(ResizeableChanged e) {
        this.uiManager.onResizeableChanged();
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired e) {
        if (e.getScriptId() == 914 && !this.uiManager.isUiCreated()) {
            this.uiManager.createTab(this.uiManager.getEquipmentOverlay());
            this.uiManager.setUiCreated(true);
        }
    }

    @Subscribe
    public void onClientTick(ClientTick e) {
        this.uiManager.onClientTick();
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded e) {
        if (e.getTarget().equals(FORCE_RIGHT_CLICK_MENU_FLAG)) {
            this.forceRightClickFlag = true;
        }
    }

    @Subscribe
    public void onMenuShouldLeftClick(MenuShouldLeftClick e) {
        MenuEntry[] menuEntries;
        if (!this.forceRightClickFlag) {
            return;
        }
        this.forceRightClickFlag = false;
        for (MenuEntry entry : menuEntries = this.client.getMenuEntries()) {
            if (!entry.getTarget().equals(FORCE_RIGHT_CLICK_MENU_FLAG)) continue;
            e.setForceRightClick(true);
            return;
        }
    }

    public MouseWheelEvent mouseWheelMoved(MouseWheelEvent event) {
        this.uiManager.mouseWheelMoved(event);
        return event;
    }

    public BodyKit getBodyKit() {
        if (this.client.getLocalPlayer() == null) {
            return null;
        }
        return this.client.getLocalPlayer().getPlayerComposition().isFemale() ? BodyKit.FEMME : BodyKit.MASC;
    }

    public UIManager getUIManager() {
        return (UIManager)this.uiManagerProvider.get();
    }
}

