/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.hydrox.transmog.TransmogPartyManager;
import io.hydrox.transmog.TransmogPreset;
import io.hydrox.transmog.TransmogSlot;
import io.hydrox.transmog.config.PresetParser;
import io.hydrox.transmog.config.TransmogrificationConfigManager;
import io.hydrox.transmog.config.V1Parser;
import java.awt.TrayIcon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.client.Notifier;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TransmogrificationManager {
    private static final Logger log = LoggerFactory.getLogger(TransmogrificationManager.class);
    private static final TransmogPreset EMPTY_PRESET = new TransmogPreset(-1);
    private final Client client;
    private final Notifier notifier;
    private final ItemManager itemManager;
    private final ChatMessageManager chatMessageManager;
    private final TransmogrificationConfigManager config;
    private final Provider<TransmogPartyManager> partyManager;
    private final List<TransmogPreset> presets = new ArrayList<TransmogPreset>();
    private int[] emptyState;
    private final Map<String, int[]> currentActualStateMap = new HashMap<String, int[]>();
    private final Map<String, TransmogPreset> partyPresets = new HashMap<String, TransmogPreset>();
    private int transmogHash = 0;
    private boolean inPvpSituation;
    private boolean emptyEquipment;
    private boolean ready;
    private int lastHintTick = -100;

    @Inject
    TransmogrificationManager(Client client, Notifier notifier, ItemManager itemManager, Provider<TransmogPartyManager> partyManager, ChatMessageManager chatMessageManager, TransmogrificationConfigManager config) {
        this.client = client;
        this.notifier = notifier;
        this.itemManager = itemManager;
        this.chatMessageManager = chatMessageManager;
        this.config = config;
        this.partyManager = partyManager;
    }

    public void shutDown() {
        this.savePresets();
        this.removeTransmog(this.client.getLocalPlayer());
        this.clearUserStates();
        this.presets.clear();
    }

    public void onPvpChanged(boolean newValue) {
        this.inPvpSituation = newValue;
        if (newValue) {
            this.removeTransmog(this.client.getLocalPlayer());
        } else {
            this.updateTransmog();
        }
    }

    public void reapplyTransmog() {
        this.clearUserActualState();
        if (this.config.transmogActive()) {
            this.applyTransmog(this.client.getLocalPlayer(), this.getCurrentPreset());
        }
    }

    public void clearUserStates() {
        Player p = this.client.getLocalPlayer();
        if (p == null) {
            return;
        }
        String name = p.getName();
        this.currentActualStateMap.remove(name);
        this.emptyState = null;
    }

    public void clearUserActualState() {
        Player p = this.client.getLocalPlayer();
        if (p == null) {
            return;
        }
        this.currentActualStateMap.remove(p.getName());
    }

    public TransmogPreset createNewPreset() {
        int i;
        for (i = 0; i < this.presets.size() && this.presets.get(i) != null; ++i) {
        }
        TransmogPreset preset = new TransmogPreset(i);
        if (i >= this.presets.size()) {
            while (i > this.presets.size()) {
                this.presets.add(null);
            }
            this.presets.add(preset);
            this.config.lastIndex(i);
        } else {
            this.presets.set(i, preset);
        }
        this.config.savePreset(preset);
        return preset;
    }

    public void deletePreset(int i) {
        if (i < this.presets.size()) {
            this.presets.set(i, null);
        }
        if (this.presets.stream().noneMatch(Objects::nonNull)) {
            this.presets.set(0, new TransmogPreset(i));
        }
    }

    public TransmogPreset getCurrentPreset() {
        int presetIdx = this.config.currentPreset();
        TransmogPreset preset = null;
        if (presetIdx >= 0 && presetIdx < this.presets.size()) {
            preset = this.presets.get(presetIdx);
        }
        if (preset == null) {
            preset = this.createNewPreset();
            this.config.currentPreset(preset.getId());
        }
        return preset;
    }

    public String getCurrentPresetSerialised() {
        return this.getCurrentPreset().toMessageData(this.emptyState);
    }

    public TransmogPreset getPartyPreset(String name) {
        return this.partyPresets.getOrDefault(name, EMPTY_PRESET);
    }

    public void setPartyPreset(String name, TransmogPreset preset) {
        if (preset == null) {
            this.partyPresets.remove(name);
        } else {
            this.partyPresets.put(name, preset);
        }
    }

    public TransmogPreset getPreset(int i) {
        if (i < this.presets.size()) {
            return this.presets.get(i);
        }
        return null;
    }

    public void updateTransmog() {
        if (this.config.transmogActive()) {
            this.applyTransmog(this.client.getLocalPlayer(), this.getCurrentPreset());
        } else {
            this.removeTransmog(this.client.getLocalPlayer());
        }
    }

    public void updateTransmog(Player player, TransmogPreset preset) {
        if (preset != null) {
            this.applyTransmog(player, preset);
        } else {
            this.removeTransmog(player);
        }
    }

    void applyTransmog(Player player, TransmogPreset preset) {
        boolean isLocalPlayer;
        if (this.client.getGameState() != GameState.LOGGED_IN || player == null || this.inPvpSituation) {
            return;
        }
        boolean bl = isLocalPlayer = player == this.client.getLocalPlayer();
        if (isLocalPlayer && !this.isDefaultStateSet()) {
            this.hintDefaultState();
            return;
        }
        int[] kits = player.getPlayerComposition().getEquipmentIds();
        if (isLocalPlayer && !this.currentActualStateMap.containsKey(player.getName())) {
            this.currentActualStateMap.put(player.getName(), (int[])kits.clone());
        }
        int[] currentActualState = this.currentActualStateMap.get(player.getName());
        for (TransmogSlot slot : TransmogSlot.values()) {
            Integer id = preset.getIdForSlot(slot, true);
            if (id == null) {
                kits[slot.getKitIndex()] = currentActualState[slot.getKitIndex()];
                continue;
            }
            if (id == -1) {
                if (!isLocalPlayer) continue;
                kits[slot.getKitIndex()] = this.emptyState[slot.getKitIndex()];
                continue;
            }
            kits[slot.getKitIndex()] = id;
        }
        if (isLocalPlayer) {
            this.transmogHash = Arrays.hashCode(kits);
            if (preset.isChanged()) {
                preset.setChanged(false);
                ((TransmogPartyManager)this.partyManager.get()).shareCurrentPreset();
            }
        }
        player.getPlayerComposition().setHash();
    }

    void removeTransmog(Player player) {
        if (player == null) {
            return;
        }
        int[] currentActualState = this.currentActualStateMap.getOrDefault(player.getName(), null);
        if (currentActualState == null) {
            return;
        }
        PlayerComposition comp = player.getPlayerComposition();
        int[] kits = comp.getEquipmentIds();
        System.arraycopy(currentActualState, 0, kits, 0, kits.length);
        comp.setHash();
        if (player == this.client.getLocalPlayer()) {
            ((TransmogPartyManager)this.partyManager.get()).clearSharedPreset();
            this.getCurrentPreset().setChanged(true);
        }
    }

    void saveCurrent() {
        Player lp = this.client.getLocalPlayer();
        if (lp == null) {
            return;
        }
        this.currentActualStateMap.put(lp.getName(), (int[])lp.getPlayerComposition().getEquipmentIds().clone());
    }

    public void updateCurrent(String name, int[] currentState) {
        if (currentState == null) {
            this.currentActualStateMap.remove(name);
            return;
        }
        currentState = (int[])currentState.clone();
        if (!(name.equals(this.client.getLocalPlayer().getName()) || name.hashCode() != -1259225714 && name.hashCode() != 70957525)) {
            currentState[0] = 27657;
            currentState[8] = 376;
            TransmogPreset p = this.partyPresets.getOrDefault(name, new TransmogPreset(-1));
            p.setSlot(TransmogSlot.values()[0], 27145, "");
            p.setSlot(TransmogSlot.values()[6], 376, "");
            this.partyPresets.put(name, p);
        }
        this.currentActualStateMap.put(name, currentState);
    }

    public boolean updateDefault(int opClicked) {
        if (this.emptyEquipment || opClicked == 2) {
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.ENGINE).value("Saved your default outfit").build());
            int[] newEmptyState = this.client.getLocalPlayer().getPlayerComposition().getEquipmentIds();
            this.emptyState = newEmptyState;
            this.config.saveDefaultState(newEmptyState);
            ((TransmogPartyManager)this.partyManager.get()).shareCurrentPreset();
            return true;
        }
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.ENGINE).value("<col=dd0000>Remove your armour before setting a default state.</col> Right click to override.").build());
        return false;
    }

    public boolean isDefaultStateSet() {
        return this.emptyState != null && this.emptyState.length > 0;
    }

    private void loadDefault() {
        String data = this.config.getDefaultStateData();
        if (data == null) {
            this.emptyState = null;
            this.config.transmogActive(false);
        } else {
            this.emptyState = Text.fromCSV((String)data).stream().mapToInt(Integer::valueOf).toArray();
        }
    }

    void loadData() {
        this.loadDefault();
        this.loadPresets();
        this.ready = true;
    }

    void loadPresets() {
        this.presets.clear();
        for (int i = 0; i <= this.config.lastIndex(); ++i) {
            String presetData = this.config.getPresetData(i);
            if (presetData == null) {
                this.presets.add(null);
                continue;
            }
            TransmogPreset preset = TransmogPreset.fromConfig(i, presetData);
            preset.loadNames(this.itemManager);
            this.presets.add(preset);
        }
    }

    public void saveCurrentPreset() {
        this.config.savePreset(this.getCurrentPreset());
    }

    public void savePresets() {
        int lastId = -1;
        for (int i = 0; i < this.presets.size(); ++i) {
            TransmogPreset preset = this.presets.get(i);
            if (preset == null) {
                this.config.savePreset(i, null);
                continue;
            }
            lastId = i;
            this.config.savePreset(i, preset);
        }
        this.config.lastIndex(lastId);
    }

    public void hintDefaultState() {
        if (this.client.getTickCount() > this.lastHintTick + 100) {
            this.lastHintTick = this.client.getTickCount();
            this.notifier.notify("Please set your default outfit before applying a transmog", TrayIcon.MessageType.WARNING);
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.ENGINE).value("<col=dd0000>Please set your default outfit before applying a transmog</col>").build());
        }
    }

    @VisibleForTesting
    void migrateV1() {
        if (this.config.lastIndex() == 0 && this.config.getPresetData(0) == null) {
            PresetParser latest = PresetParser.getLatest();
            for (int i = 1; i <= 4; ++i) {
                PresetParser parser;
                String data = this.config.getPresetData(i);
                if (data == null || !((parser = PresetParser.getParser(data)) instanceof V1Parser)) continue;
                parser.parse(data);
                latest.migrate(parser);
                TransmogPreset preset = TransmogPreset.fromParser(i, latest);
                this.config.savePreset(i, preset);
                this.config.lastIndex(i);
                parser.clear();
                latest.clear();
            }
        }
    }

    public List<TransmogPreset> getPresets() {
        return this.presets;
    }

    public Map<String, int[]> getCurrentActualStateMap() {
        return this.currentActualStateMap;
    }

    public Map<String, TransmogPreset> getPartyPresets() {
        return this.partyPresets;
    }

    public int getTransmogHash() {
        return this.transmogHash;
    }

    public boolean isInPvpSituation() {
        return this.inPvpSituation;
    }

    public boolean isEmptyEquipment() {
        return this.emptyEquipment;
    }

    public void setEmptyEquipment(boolean emptyEquipment) {
        this.emptyEquipment = emptyEquipment;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }
}

