/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog;

import io.hydrox.transmog.ui.CustomSprites;
import java.util.HashMap;
import java.util.Map;
import net.runelite.client.util.Text;

public enum TransmogSlot {
    HEAD(0, 156, SlotType.ITEM),
    CAPE(1, 157, SlotType.ITEM),
    NECK(2, 158, SlotType.ITEM),
    TORSO(4, 161, SlotType.ITEM),
    SLEEVES(6, CustomSprites.SLOT_SLEEVES.getSpriteId(), SlotType.SPECIAL),
    LEGS(7, 163, SlotType.ITEM),
    HAIR(8, CustomSprites.SLOT_HAIR.getSpriteId(), SlotType.SPECIAL),
    HANDS(9, 164, SlotType.ITEM),
    BOOTS(10, 165, SlotType.ITEM),
    JAW(11, CustomSprites.SLOT_JAW.getSpriteId(), SlotType.SPECIAL);

    private static Map<Integer, TransmogSlot> INDEXES;
    private final int kitIndex;
    private final int spriteID;
    private final SlotType slotType;

    static TransmogSlot fromIndex(int idx) {
        return INDEXES.get(idx);
    }

    public String getName() {
        return Text.titleCase((Enum)this);
    }

    private TransmogSlot(int kitIndex, int spriteID, SlotType slotType) {
        this.kitIndex = kitIndex;
        this.spriteID = spriteID;
        this.slotType = slotType;
    }

    public int getKitIndex() {
        return this.kitIndex;
    }

    public int getSpriteID() {
        return this.spriteID;
    }

    public SlotType getSlotType() {
        return this.slotType;
    }

    static {
        INDEXES = new HashMap<Integer, TransmogSlot>();
        for (TransmogSlot kit : TransmogSlot.values()) {
            INDEXES.put(kit.getKitIndex(), kit);
        }
    }

    public static enum SlotType {
        ITEM,
        SPECIAL;

    }
}

