/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog;

import io.hydrox.transmog.Mapping;
import io.hydrox.transmog.MappingMapping;
import io.hydrox.transmog.TransmogSlot;
import io.hydrox.transmog.config.PresetParser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.runelite.client.game.ItemManager;

public class TransmogPreset {
    static final int EMPTY = -1;
    static final Integer IGNORE = null;
    private final Map<TransmogSlot, Integer> overrides = new HashMap<TransmogSlot, Integer>();
    private final Map<TransmogSlot, String> names = new HashMap<TransmogSlot, String>();
    private int id;
    private int icon;
    private String name;
    private boolean changed = false;

    public TransmogPreset(int id) {
        this(id, -1, "");
    }

    public TransmogPreset(int id, int icon, String name) {
        for (TransmogSlot slot : TransmogSlot.values()) {
            if (slot.getSlotType() != TransmogSlot.SlotType.SPECIAL) continue;
            this.setDefaultSlot(slot);
        }
        this.id = id;
        this.icon = icon;
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        if (this.name.isEmpty() && this.icon == -1) {
            return "[#" + this.id + "]";
        }
        return this.name;
    }

    public static TransmogPreset fromConfig(int id, String configData) {
        PresetParser parser = PresetParser.getParser(configData);
        parser.parse(configData);
        return TransmogPreset.fromParser(id, parser);
    }

    public static TransmogPreset fromParser(int id, PresetParser parser) {
        TransmogPreset preset = new TransmogPreset(id, parser.getIcon(), parser.getName());
        for (int i = 0; i < parser.getSlotValues().size(); ++i) {
            TransmogSlot slot = TransmogSlot.values()[i];
            String val = parser.getSlotValues().get(i);
            if (val.equals("null")) {
                preset.overrides.remove((Object)slot);
                continue;
            }
            preset.overrides.put(slot, Integer.parseInt(val));
        }
        return preset;
    }

    public void setDefaultSlot(TransmogSlot slot) {
        this.setSlot(slot, -1, "");
    }

    public void setSlot(TransmogSlot slot, int id, String name) {
        this.overrides.put(slot, id);
        this.names.put(slot, name);
        this.changed = true;
    }

    public void clearSlot(TransmogSlot slot) {
        this.overrides.remove((Object)slot);
        this.names.remove((Object)slot);
    }

    public Integer getIdForSlot(TransmogSlot slot, boolean forKit) {
        Integer transmog = this.overrides.get((Object)slot);
        if (transmog == null) {
            if (slot.getSlotType() == TransmogSlot.SlotType.SPECIAL && forKit) {
                return 0;
            }
            return IGNORE;
        }
        if (transmog == -1) {
            return -1;
        }
        if (slot.getSlotType() == TransmogSlot.SlotType.ITEM) {
            return transmog + (forKit ? 512 : 0);
        }
        if (forKit) {
            return transmog;
        }
        Function<Integer, Mapping> m = MappingMapping.fromSlot(slot).getFromKit();
        if (m == null) {
            return transmog;
        }
        return Optional.ofNullable(m.apply(transmog)).map(Mapping::modelId).orElse(-1);
    }

    public String getName(TransmogSlot slot) {
        return this.names.get((Object)slot);
    }

    public String toConfig() {
        if (this.overrides.isEmpty()) {
            return null;
        }
        HashMap<TransmogSlot, Integer> merged = new HashMap<TransmogSlot, Integer>();
        Arrays.asList(TransmogSlot.values()).forEach(tk -> merged.put((TransmogSlot)((Object)tk), (Integer)null));
        merged.putAll(this.overrides);
        String slots = merged.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).map(v -> v == null ? "null" : String.valueOf(v)).collect(Collectors.joining(","));
        return "\"" + this.icon + "," + this.name + "," + slots;
    }

    public String toMessageData(int[] empty) {
        if (this.overrides.isEmpty() || empty == null) {
            return "";
        }
        Integer[] merged = new Integer[TransmogSlot.values().length];
        for (int i = 0; i < merged.length; ++i) {
            TransmogSlot slot = TransmogSlot.values()[i];
            Integer override = this.overrides.get((Object)slot);
            merged[i] = override != null && override == -1 ? Integer.valueOf(empty[slot.getKitIndex()]) : override;
        }
        return Arrays.stream(merged).map(v -> v == IGNORE ? "null" : String.valueOf(v)).collect(Collectors.joining(","));
    }

    void loadNames(ItemManager itemManager) {
        for (Map.Entry<TransmogSlot, Integer> entry : this.overrides.entrySet()) {
            Mapping mapping;
            Integer id = entry.getValue();
            if (id == null || id == -1) continue;
            TransmogSlot slot = entry.getKey();
            String name = slot.getSlotType() == TransmogSlot.SlotType.SPECIAL ? ((mapping = MappingMapping.fromSlot(slot).getFromKit().apply(id)) != null ? mapping.prettyName() : "Empty") : itemManager.getItemComposition(id.intValue()).getName();
            this.names.put(entry.getKey(), name);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getIcon() {
        return this.icon;
    }

    public void setIcon(int icon) {
        this.icon = icon;
    }

    public String getName() {
        return this.name;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }
}

