/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.hydrox.transmog.TransmogPreset;
import io.hydrox.transmog.TransmogUpdateMessage;
import io.hydrox.transmog.TransmogrificationManager;
import io.hydrox.transmog.config.TransmogrificationConfigManager;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.events.PartyChanged;
import net.runelite.client.party.PartyMember;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.messages.PartyMemberMessage;
import net.runelite.client.party.messages.PartyMessage;

@Singleton
public class TransmogPartyManager {
    static final int RATE_LIMIT = 1;
    private final Client client;
    private final ClientThread clientThread;
    private final TransmogrificationManager transmogManager;
    private final TransmogrificationConfigManager configManager;
    private final PartyService partyService;
    private final Map<String, Player> playerMapByName = new HashMap<String, Player>();
    private final Map<Long, String> playerMapByMemberId = new HashMap<Long, String>();
    private int lastSend = 0;
    private PartyMessage messageToSend;

    @Inject
    TransmogPartyManager(Client client, ClientThread clientThread, TransmogrificationManager transmogManager, PartyService partyService, TransmogrificationConfigManager configManager) {
        this.client = client;
        this.clientThread = clientThread;
        this.transmogManager = transmogManager;
        this.partyService = partyService;
        this.configManager = configManager;
    }

    public void onPlayerSpawned(Player spawned) {
        if (spawned == this.client.getLocalPlayer()) {
            return;
        }
        this.playerMapByName.put(spawned.getName(), spawned);
        this.transmogManager.updateCurrent(spawned.getName(), spawned.getPlayerComposition().getEquipmentIds());
        this.transmogManager.applyTransmog(spawned, this.transmogManager.getPartyPreset(spawned.getName()));
    }

    public void onGameTick() {
        if (this.messageToSend != null && this.lastSend + 1 < this.client.getTickCount()) {
            this.lastSend = this.client.getTickCount();
            this.partyService.send(this.messageToSend);
            this.messageToSend = null;
        }
    }

    public void onPlayerDespawned(Player despawned) {
        this.playerMapByName.remove(despawned.getName());
    }

    public void onTransmogUpdateMessage(TransmogUpdateMessage e) {
        if (this.partyService.getLocalMember().getMemberId() == e.getMemberId()) {
            return;
        }
        PartyMember member = this.partyService.getMemberById(e.getMemberId());
        String name = member.getDisplayName();
        if (name.equals("<unknown>")) {
            if (this.transmogManager.getPartyPreset(e.getName()) != null) {
                return;
            }
            name = e.getName();
        }
        TransmogPreset preset = e.getPresetData() == null ? null : TransmogPreset.fromConfig(-1, e.getPresetData());
        this.transmogManager.setPartyPreset(name, preset);
        Player player = this.playerMapByName.getOrDefault(name, null);
        if (player == null) {
            return;
        }
        this.clientThread.invoke(() -> this.transmogManager.updateTransmog(player, preset));
    }

    public void onStatusUpdate() {
        this.playerMapByMemberId.clear();
        for (PartyMember pm : this.partyService.getMembers()) {
            String name;
            if (pm.getMemberId() == this.partyService.getLocalMember().getMemberId() || "<unknown>".equals(name = pm.getDisplayName())) continue;
            this.playerMapByMemberId.put(pm.getMemberId(), name);
            Player player = this.playerMapByName.getOrDefault(name, null);
            if (player == null) continue;
            this.clientThread.invoke(() -> this.transmogManager.updateTransmog(player, this.transmogManager.getPartyPreset(name)));
        }
    }

    public void clearUser(long memberId) {
        String name = this.playerMapByMemberId.getOrDefault(memberId, null);
        if (name == null) {
            return;
        }
        this.transmogManager.setPartyPreset(name, null);
        if (this.playerMapByName.containsKey(name)) {
            this.clientThread.invoke(() -> this.transmogManager.removeTransmog(this.playerMapByName.get(name)));
        }
        this.playerMapByMemberId.remove(memberId);
    }

    public Runnable onPartyChanged(PartyChanged e) {
        if (e.getPartyId() == null) {
            for (long id : this.playerMapByMemberId.keySet()) {
                this.clearUser(id);
            }
        }
        if (this.client.getGameState() != GameState.LOGGED_IN || e.getPartyId() == null || this.client.getLocalPlayer().getName() == null) {
            return null;
        }
        return this::shareCurrentPreset;
    }

    private boolean shouldSharePreset() {
        return this.configManager.transmogActive() && this.configManager.transmitToParty();
    }

    void shareCurrentPreset() {
        if (this.partyService.isInParty() && this.client.getGameState() == GameState.LOGGED_IN) {
            this.queueSend(new TransmogUpdateMessage(this.client.getLocalPlayer().getName(), this.shouldSharePreset() ? this.transmogManager.getCurrentPresetSerialised() : null));
        }
    }

    void clearSharedPreset() {
        if (this.partyService.isInParty()) {
            this.queueSend(new TransmogUpdateMessage(this.client.getLocalPlayer().getName(), null));
        }
    }

    public void setShareWithParty(boolean state) {
        this.configManager.transmitToParty(state);
        this.shareCurrentPreset();
    }

    void queueSend(PartyMemberMessage message) {
        this.messageToSend = message;
    }
}

