/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog;

import io.hydrox.transmog.BodyKit;
import io.hydrox.transmog.Mapping;
import java.util.HashMap;
import java.util.Map;

public enum SleeveMapping implements Mapping
{
    EMPTY("Empty", null, -1, -1),
    SHORT_SLEEVES("Short sleeves", BodyKit.FEMME, 332, 317),
    BARE_ARMS("Bare arms", BodyKit.FEMME, 351, 318),
    MUSCLEY("Muscley", BodyKit.FEMME, 346, 319),
    LONG_SLEEVED("Long sleeved", BodyKit.FEMME, 348, 320),
    LARGE_CUFFS("Large cuffs", BodyKit.FEMME, 343, 321),
    FRILLY("Frilly", BodyKit.FEMME, 28364, 322),
    SWEATER("Sweater", BodyKit.FEMME, 28365, 351),
    WHITE_CUFFS("White cuffs", BodyKit.FEMME, 28368, 352),
    THIN_STRIPE("Thin stripe", BodyKit.FEMME, 28366, 353),
    TATTY("Tatty", BodyKit.FEMME, 28367, 354),
    BARE_SHOULDERS("Bare shoulders", BodyKit.FEMME, 28369, 355),
    REGULAR("Regular", BodyKit.MASC, 151, 282),
    MUSCLEBOUND("Musclebound", BodyKit.MASC, 167, 283),
    LOOSE_SLEEVED("Loose sleeved", BodyKit.MASC, 170, 284),
    LARGE_CUFFED("Large cuffed", BodyKit.MASC, 162, 285),
    THIN_SLEEVED("Thin sleeved", BodyKit.MASC, 163, 286),
    SHOULDER_PADS("Shoulder pads", BodyKit.MASC, 158, 287),
    THIN_STRIPE_M("Thin stripe", BodyKit.MASC, 28342, 288),
    THICK_STRIPE("Thick stripe", BodyKit.MASC, 28345, 340),
    WHITE_CUFFS_M("White cuffs", BodyKit.MASC, 28343, 341),
    PRINCELY("Princely", BodyKit.MASC, 28340, 342),
    TATTY_M("Tatty", BodyKit.MASC, 28344, 343),
    RIPPED("Ripped", BodyKit.MASC, 28341, 344);

    private final String name;
    private final BodyKit bodyKit;
    private final int modelID;
    private final int kitID;
    private static final Map<Integer, SleeveMapping> FROM_KIT;
    private static final Map<Integer, SleeveMapping> FROM_MODEL;

    public static SleeveMapping fromKitID(int kitID) {
        return FROM_KIT.get(kitID);
    }

    public static SleeveMapping fromModelID(int modelID) {
        return FROM_MODEL.get(modelID);
    }

    @Override
    public String prettyName() {
        return this.name;
    }

    @Override
    public BodyKit bodyKit() {
        return this.bodyKit;
    }

    @Override
    public int modelId() {
        return this.modelID;
    }

    @Override
    public int kitId() {
        return this.kitID;
    }

    public String getName() {
        return this.name;
    }

    public BodyKit getBodyKit() {
        return this.bodyKit;
    }

    public int getModelID() {
        return this.modelID;
    }

    public int getKitID() {
        return this.kitID;
    }

    private SleeveMapping(String name, BodyKit bodyKit, int modelID, int kitID) {
        this.name = name;
        this.bodyKit = bodyKit;
        this.modelID = modelID;
        this.kitID = kitID;
    }

    static {
        FROM_KIT = new HashMap<Integer, SleeveMapping>();
        FROM_MODEL = new HashMap<Integer, SleeveMapping>();
        for (SleeveMapping mapping : SleeveMapping.values()) {
            FROM_KIT.put(mapping.kitID, mapping);
            FROM_MODEL.put(mapping.modelID, mapping);
        }
    }
}

