/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog;

import io.hydrox.transmog.FacialHairMapping;
import io.hydrox.transmog.HairMapping;
import io.hydrox.transmog.Mapping;
import io.hydrox.transmog.SleeveMapping;
import io.hydrox.transmog.TransmogSlot;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public enum MappingMapping {
    HAIR(TransmogSlot.HAIR, HairMapping.class, HairMapping::fromKitID, HairMapping::fromModelID, 600, 10),
    JAW(TransmogSlot.JAW, FacialHairMapping.class, FacialHairMapping::fromKitID, FacialHairMapping::fromModelID, 600, 10),
    SLEEVES(TransmogSlot.SLEEVES, SleeveMapping.class, SleeveMapping::fromKitID, SleeveMapping::fromModelID, 1200, 55);

    private final TransmogSlot slot;
    private final Class<? extends Mapping> mapping;
    private final Function<Integer, Mapping> fromKit;
    private final Function<Integer, Mapping> fromModel;
    private final int modelZoom;
    private final int yOffset;
    private static final Map<TransmogSlot, MappingMapping> MAP;

    public static MappingMapping fromSlot(TransmogSlot slot) {
        return MAP.get((Object)slot);
    }

    public TransmogSlot getSlot() {
        return this.slot;
    }

    public Class<? extends Mapping> getMapping() {
        return this.mapping;
    }

    public Function<Integer, Mapping> getFromKit() {
        return this.fromKit;
    }

    public Function<Integer, Mapping> getFromModel() {
        return this.fromModel;
    }

    public int getModelZoom() {
        return this.modelZoom;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    private MappingMapping(TransmogSlot slot, Class<? extends Mapping> mapping, Function<Integer, Mapping> fromKit, Function<Integer, Mapping> fromModel, int modelZoom, int yOffset) {
        this.slot = slot;
        this.mapping = mapping;
        this.fromKit = fromKit;
        this.fromModel = fromModel;
        this.modelZoom = modelZoom;
        this.yOffset = yOffset;
    }

    static {
        MAP = new HashMap<TransmogSlot, MappingMapping>();
        for (MappingMapping m : MappingMapping.values()) {
            MAP.put(m.slot, m);
        }
    }
}

