/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.transmog;

import io.hydrox.transmog.BodyKit;
import io.hydrox.transmog.Mapping;
import java.util.HashMap;
import java.util.Map;

public enum FacialHairMapping implements Mapping
{
    EMPTY("Empty", -1, -1),
    NONE("None", 47825, 270),
    GOATEE("Goatee", 47814, 266),
    LONG("Long", 47837, 267),
    MEDIUM("Medium", 47820, 268),
    MOUSTACHE("Moustache", 47787, 269),
    SHORT("Short", 47767, 271),
    POINTY("Pointy", 47784, 272),
    SPLIT("Split", 47840, 273),
    HANDLEBAR("Handlebar", 47830, 367),
    MUTTON("Mutton", 47797, 368),
    FULL_MUTTON("Full Mutton", 47783, 369),
    BIG_MOUSTACHE("Big Moustache", 47770, 370),
    WAXED_MOUSTACHE("Waxed Moustache", 47795, 371),
    DALI("Dali", 47789, 372),
    VIZIER("Vizier", 47826, 373);

    private final String name;
    private final int modelID;
    private final int kitID;
    private static final Map<Integer, FacialHairMapping> FROM_KIT;
    private static final Map<Integer, FacialHairMapping> FROM_MODEL;

    public static FacialHairMapping fromKitID(int kitID) {
        return FROM_KIT.get(kitID);
    }

    public static FacialHairMapping fromModelID(int modelID) {
        return FROM_MODEL.get(modelID);
    }

    @Override
    public String prettyName() {
        return this.name;
    }

    @Override
    public BodyKit bodyKit() {
        return BodyKit.MASC;
    }

    @Override
    public int modelId() {
        return this.modelID;
    }

    @Override
    public int kitId() {
        return this.kitID;
    }

    public String getName() {
        return this.name;
    }

    public int getModelID() {
        return this.modelID;
    }

    public int getKitID() {
        return this.kitID;
    }

    private FacialHairMapping(String name, int modelID, int kitID) {
        this.name = name;
        this.modelID = modelID;
        this.kitID = kitID;
    }

    static {
        FROM_KIT = new HashMap<Integer, FacialHairMapping>();
        FROM_MODEL = new HashMap<Integer, FacialHairMapping>();
        for (FacialHairMapping mapping : FacialHairMapping.values()) {
            FROM_KIT.put(mapping.kitID, mapping);
            FROM_MODEL.put(mapping.modelID, mapping);
        }
    }
}

