/*
 * Decompiled with CFR 0.152.
 */
package com.wookkeey.sandstonebucketscounter;

import com.google.inject.Provides;
import com.wookkeey.sandstonebucketscounter.SandstoneBucketsCounterConfig;
import com.wookkeey.sandstonebucketscounter.SandstoneBucketsCounterOverlay;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Sandstone Buckets Counter", description="Show helpful counter of how many buckets of sand in sandstones player has in their inventory.", tags={"sandstone", "desert quarry", "quarry", "bucket of sand"})
public class SandstoneBucketsCounterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SandstoneBucketsCounterPlugin.class);
    private static final int DESERT_QUARRY_REGION = 12589;
    private static final Pattern GRINDER_DEPOSIT_BUCKET_PATTERN = Pattern.compile("The grinder is now holding enough sandstone equivalent to (?<filledBucketCount>[\\d,]+) buckets of sand.");
    private static final Pattern GRINDER_CHECK_BUCKET_PATTERN = Pattern.compile("I have (?<emptyBucketCount>[\\d,]+) of your buckets and you've ground enough sandstone for (?<filledBucketCount>[\\d,]+) buckets of sand.");
    private static final String CONFIG_GRINDER_STORAGE_KEY = "numStoredInGrinder";
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private SandstoneBucketsCounterOverlay overlay;
    private int inventoryCount;
    private int grinderCount;
    private boolean isInDesertQuarry;

    protected void startUp() throws Exception {
        this.reset();
        this.overlayManager.add((Overlay)this.overlay);
        this.clientThread.invokeLater(() -> {
            ItemContainer container = this.client.getItemContainer(InventoryID.INVENTORY);
            if (container != null) {
                this.calculateInventory(container.getItems());
            }
        });
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.reset();
    }

    private void reset() {
        this.inventoryCount = 0;
    }

    private boolean isInDesertQuarryRegion() {
        if (this.client.getLocalPlayer() != null) {
            return this.client.getLocalPlayer().getWorldLocation().getRegionID() == 12589;
        }
        return false;
    }

    private void getGrinderChatbox() {
        Widget npcDialog = this.client.getWidget(WidgetInfo.DIALOG_NPC_TEXT);
        if (npcDialog == null) {
            return;
        }
        Widget name = this.client.getWidget(WidgetInfo.DIALOG_NPC_NAME);
        Widget head = this.client.getWidget(WidgetInfo.DIALOG_NPC_HEAD_MODEL);
        if (name == null || head == null || head.getModelType() != 2) {
            return;
        }
        int npcId = head.getModelId();
        if (npcId != 6771) {
            return;
        }
        String npcText = Text.sanitizeMultilineText((String)npcDialog.getText());
        Matcher textMatcher = GRINDER_DEPOSIT_BUCKET_PATTERN.matcher(npcText);
        if (!textMatcher.find() && !(textMatcher = GRINDER_CHECK_BUCKET_PATTERN.matcher(npcText)).find()) {
            return;
        }
        this.grinderCount = Integer.parseInt(textMatcher.group("filledBucketCount").replace(",", ""));
        this.configManager.setRSProfileConfiguration("sandstonebucketscounter", CONFIG_GRINDER_STORAGE_KEY, (Object)this.grinderCount);
    }

    public int getGrinderCount() {
        Integer configGrinderCount = (Integer)this.configManager.getRSProfileConfiguration("sandstonebucketscounter", CONFIG_GRINDER_STORAGE_KEY, Integer.TYPE);
        return configGrinderCount != null ? configGrinderCount : this.grinderCount;
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (!this.isInDesertQuarryRegion()) {
            if (this.isInDesertQuarry) {
                log.debug("Left Desert Quarry region");
                this.reset();
            }
            this.isInDesertQuarry = false;
            return;
        }
        if (!this.isInDesertQuarry) {
            this.reset();
            log.debug("Entered Desert Quarry region");
        }
        this.isInDesertQuarry = true;
        this.getGrinderChatbox();
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer container = event.getItemContainer();
        if (!this.isInDesertQuarry || container != this.client.getItemContainer(InventoryID.INVENTORY)) {
            return;
        }
        this.calculateInventory(container.getItems());
    }

    @Provides
    SandstoneBucketsCounterConfig provideConfig(ConfigManager configManager) {
        return (SandstoneBucketsCounterConfig)configManager.getConfig(SandstoneBucketsCounterConfig.class);
    }

    private void calculateInventory(Item[] inv) {
        this.inventoryCount = 0;
        for (Item item : inv) {
            this.inventoryCount += SandstoneBucketsCounterPlugin.getBucketsPotentialCount(item.getId());
        }
    }

    private static int getBucketsPotentialCount(int id) {
        switch (id) {
            case 6971: {
                return 1;
            }
            case 6973: {
                return 2;
            }
            case 6975: {
                return 4;
            }
            case 6977: {
                return 8;
            }
        }
        return 0;
    }

    int getInventoryCount() {
        return this.inventoryCount;
    }

    boolean isInDesertQuarry() {
        return this.isInDesertQuarry;
    }
}

