/*
 * Decompiled with CFR 0.152.
 */
package com.wookkeey.sandstonebucketscounter;

import com.wookkeey.sandstonebucketscounter.SandstoneBucketsCounterConfig;
import com.wookkeey.sandstonebucketscounter.SandstoneBucketsCounterPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

class SandstoneBucketsCounterOverlay
extends OverlayPanel {
    private final SandstoneBucketsCounterPlugin plugin;
    private final SandstoneBucketsCounterConfig sandstoneBucketsCounterConfig;

    @Inject
    private SandstoneBucketsCounterOverlay(SandstoneBucketsCounterPlugin plugin, SandstoneBucketsCounterConfig sandstoneBucketsCounterConfig) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.sandstoneBucketsCounterConfig = sandstoneBucketsCounterConfig;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Sandstone Buckets Counter Overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInDesertQuarry() || !this.sandstoneBucketsCounterConfig.showOverlay()) {
            return null;
        }
        this.panelComponent.getChildren().add(TitleComponent.builder().text("Buckets of sand").color(Color.ORANGE).build());
        int inventoryCount = this.plugin.getInventoryCount() > 0 ? this.plugin.getInventoryCount() : 0;
        this.panelComponent.getChildren().add(LineComponent.builder().left("Inventory:").right(Integer.toString(inventoryCount)).build());
        int grinderCount = this.plugin.getGrinderCount() > 0 ? this.plugin.getGrinderCount() : 0;
        this.panelComponent.getChildren().add(LineComponent.builder().left("Grinder:").right(Integer.toString(grinderCount)).build());
        return super.render(graphics);
    }
}

