/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.chatpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import net.runelite.client.plugins.chatpanel.ChatPanelConfig;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatPanelSidebar
extends PluginPanel {
    private final JTextArea publicChatArea;
    private final JTextArea privateChatArea;
    private final JTextArea clanChatArea;
    private static final int MAX_CHAT_LINES = 10000;
    private final JTextArea gameChatArea;
    private final JTabbedPane tabbedPane;
    private final ChatPanelConfig config;
    private static final Logger logger = LoggerFactory.getLogger(ChatPanelSidebar.class);

    public ChatPanelSidebar(ChatPanelConfig config) {
        this.config = config;
        this.setLayout(new BorderLayout());
        this.publicChatArea = this.createChatArea();
        this.privateChatArea = this.createChatArea();
        this.clanChatArea = this.createChatArea();
        this.gameChatArea = this.createChatArea();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Public", this.createScrollPane(this.publicChatArea));
        this.tabbedPane.addTab("Private", this.createScrollPane(this.privateChatArea));
        this.tabbedPane.addTab("Clan", this.createScrollPane(this.clanChatArea));
        this.tabbedPane.addTab("Game", this.createScrollPane(this.gameChatArea));
        this.add(this.tabbedPane, "Center");
        this.updateChatStyles();
    }

    private JTextArea createChatArea() {
        JTextArea chatArea = new JTextArea();
        chatArea.setLineWrap(true);
        chatArea.setWrapStyleWord(true);
        chatArea.setEditable(false);
        chatArea.setBorder(new EmptyBorder(10, 10, 10, 10));
        chatArea.setBackground(Color.BLACK);
        return chatArea;
    }

    private JScrollPane createScrollPane(JTextArea chatArea) {
        JScrollPane scrollPane = new JScrollPane(chatArea);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.setScrollPaneSize(scrollPane);
        return scrollPane;
    }

    private void setScrollPaneSize(JScrollPane scrollPane) {
        scrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.config.chatAreaHeight()));
        scrollPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, this.config.chatAreaHeight()));
    }

    public void updateChatStyles() {
        this.publicChatArea.setForeground(this.config.publicChatColor());
        this.publicChatArea.setFont(new Font("SansSerif", 0, this.config.publicChatFontSize()));
        this.privateChatArea.setForeground(this.config.privateChatColor());
        this.privateChatArea.setFont(new Font("SansSerif", 0, this.config.privateChatFontSize()));
        this.clanChatArea.setForeground(this.config.clanChatColor());
        this.clanChatArea.setFont(new Font("SansSerif", 0, this.config.clanChatFontSize()));
        this.gameChatArea.setForeground(this.config.gameChatColor());
        this.gameChatArea.setFont(new Font("SansSerif", 0, this.config.gameChatFontSize()));
        this.setScrollPaneSize((JScrollPane)this.tabbedPane.getComponentAt(0));
        this.setScrollPaneSize((JScrollPane)this.tabbedPane.getComponentAt(1));
        this.setScrollPaneSize((JScrollPane)this.tabbedPane.getComponentAt(2));
        this.setScrollPaneSize((JScrollPane)this.tabbedPane.getComponentAt(3));
    }

    public void addPublicChatMessage(String name, String message) {
        this.addMessageToChatArea(this.publicChatArea, "[" + name + "]: " + message);
    }

    public void addPrivateChatMessage(String name, String message) {
        this.addMessageToChatArea(this.privateChatArea, "[" + name + "]: " + message);
    }

    public void addClanChatMessage(String name, String message) {
        this.addMessageToChatArea(this.clanChatArea, "[" + name + "]: " + message);
    }

    public void addGameChatMessage(String message) {
        this.addMessageToChatArea(this.gameChatArea, message);
    }

    private void addMessageToChatArea(JTextArea chatArea, String formattedMessage) {
        SwingUtilities.invokeLater(() -> {
            JScrollPane scrollPane = (JScrollPane)chatArea.getParent().getParent();
            JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
            boolean shouldAutoScroll = verticalScrollBar.getValue() + verticalScrollBar.getVisibleAmount() == verticalScrollBar.getMaximum();
            chatArea.append(formattedMessage + "\n");
            try {
                int excess = chatArea.getLineCount() - 10000;
                if (excess > 0) {
                    int end = chatArea.getLineEndOffset(excess - 1);
                    chatArea.replaceRange("", 0, end);
                }
            }
            catch (BadLocationException e) {
                logger.error("Error managing chat lines", (Throwable)e);
            }
            if (shouldAutoScroll) {
                chatArea.setCaretPosition(chatArea.getDocument().getLength());
            }
        });
    }
}

