/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.chatpanel;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.chatpanel.ChatPanelConfig;
import net.runelite.client.plugins.chatpanel.ChatPanelSidebar;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Chat Panel", description="Capture chat messages and display them in a RuneLite panel", tags={"chat", "panel", "capture", "messages"})
public class ChatPanelPlugin
extends Plugin {
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ChatPanelConfig config;
    private ChatPanelSidebar chatPanelSidebar;
    private NavigationButton navButton;

    @Provides
    ChatPanelConfig provideConfig(ConfigManager configManager) {
        return (ChatPanelConfig)configManager.getConfig(ChatPanelConfig.class);
    }

    protected void startUp() throws Exception {
        this.chatPanelSidebar = new ChatPanelSidebar(this.config);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/ChatPanelimg.png");
        this.navButton = NavigationButton.builder().tooltip("Chat Panel").icon(icon).priority(5).panel((PluginPanel)this.chatPanelSidebar).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String cleanedName = this.cleanString(event.getName());
        String cleanedMessage = this.cleanString(event.getMessage());
        switch (event.getType()) {
            case PUBLICCHAT: {
                this.chatPanelSidebar.addPublicChatMessage(cleanedName, cleanedMessage);
                break;
            }
            case PRIVATECHAT: {
                this.chatPanelSidebar.addPrivateChatMessage(cleanedName, cleanedMessage);
                break;
            }
            case CLAN_CHAT: 
            case CLAN_MESSAGE: 
            case CLAN_GUEST_MESSAGE: 
            case CLAN_GIM_CHAT: 
            case CLAN_GUEST_CHAT: {
                this.chatPanelSidebar.addClanChatMessage(cleanedName, cleanedMessage);
                break;
            }
            case PRIVATECHATOUT: {
                this.chatPanelSidebar.addPrivateChatMessage("You", cleanedMessage);
                break;
            }
            case GAMEMESSAGE: 
            case ENGINE: 
            case NPC_EXAMINE: 
            case SPAM: 
            case ITEM_EXAMINE: 
            case OBJECT_EXAMINE: 
            case WELCOME: {
                this.chatPanelSidebar.addGameChatMessage(cleanedMessage);
            }
        }
    }

    private String cleanString(String message) {
        return message.replaceAll("<img=[0-9]+>", "");
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!"chatpanel".equals(event.getGroup())) {
            return;
        }
        this.chatPanelSidebar.updateChatStyles();
    }
}

