/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.chatpanel;

import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="chatpanel")
public interface ChatPanelConfig
extends Config {
    @ConfigSection(name="General", description="General settings", position=0)
    public static final String generalSection = "general";
    @ConfigSection(name="Public Chat", description="Settings for public chat", position=1)
    public static final String publicChatSection = "publicChat";
    @ConfigSection(name="Private Chat", description="Settings for private chat", position=2)
    public static final String privateChatSection = "privateChat";
    @ConfigSection(name="Clan Chat", description="Settings for clan chat", position=3)
    public static final String clanChatSection = "clanChat";
    @ConfigSection(name="Game Chat", description="Settings for game chat", position=4)
    public static final String gameChatSection = "gameChat";

    @Range(min=50)
    @ConfigItem(keyName="chatAreaHeight", name="Chat Area Height", description="Configures the height of the chat area. Recommended below window height", section="general")
    default public int chatAreaHeight() {
        return 750;
    }

    @ConfigItem(keyName="publicChatColor", name="Public Chat Color", description="Configures the font color of the public chat messages.", section="publicChat")
    default public Color publicChatColor() {
        return new Color(0xF1FF00);
    }

    @Range(min=5, max=50)
    @ConfigItem(keyName="publicChatFontSize", name="Public Chat Font Size", description="Configures the font size of the public chat messages.", section="publicChat")
    default public int publicChatFontSize() {
        return 10;
    }

    @ConfigItem(keyName="privateChatColor", name="Private Chat Color", description="Configures the font color of the private chat messages.", section="privateChat")
    default public Color privateChatColor() {
        return new Color(720640);
    }

    @Range(min=5, max=50)
    @ConfigItem(keyName="privateChatFontSize", name="Private Chat Font Size", description="Configures the font size of the private chat messages.", section="privateChat")
    default public int privateChatFontSize() {
        return 14;
    }

    @ConfigItem(keyName="clanChatColor", name="Clan Chat Color", description="Configures the font color of the clan chat messages.", section="clanChat")
    default public Color clanChatColor() {
        return new Color(32255);
    }

    @Range(min=5, max=50)
    @ConfigItem(keyName="clanChatFontSize", name="Clan Chat Font Size", description="Configures the font size of the clan chat messages.", section="clanChat")
    default public int clanChatFontSize() {
        return 12;
    }

    @ConfigItem(keyName="gameChatColor", name="Game Chat Color", description="Configures the font color of the game chat messages.", section="gameChat")
    default public Color gameChatColor() {
        return new Color(0xFFFFFF);
    }

    @Range(min=5, max=50)
    @ConfigItem(keyName="gameChatFontSize", name="Game Chat Font Size", description="Configures the font size of the game chat messages.", section="gameChat")
    default public int gameChatFontSize() {
        return 12;
    }
}

