/*
 * Decompiled with CFR 0.152.
 */
package com.ywcode.clientresizer;

import com.google.inject.Inject;
import com.google.inject.Provides;
import com.ywcode.clientresizer.ClientResizerConfig;
import com.ywcode.clientresizer.MonitorAttribute;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.regex.Pattern;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.Keybind;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.ProfileChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.util.HotkeyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Client Resizer", description="Allows for automatic or hotkey-based resizing of the client.", tags={"client,resize,automatic,pixels,refresh rate,game size,size,screen size,monitor,display,screen,autoresize,hotkey,hot key,stretched mode,resizable scaling,scaling"})
public class ClientResizerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClientResizerPlugin.class);
    private static boolean resizeAttributeUnchanged;
    private static boolean resizeWhenConfigProfileChanged;
    private static Dimension autoSize1Dimension;
    private static MonitorAttribute autoSize1Attribute;
    private static String autoSize1Value;
    private static Dimension autoSize2Dimension;
    private static MonitorAttribute autoSize2Attribute;
    private static String autoSize2Value;
    private static Dimension autoSize3Dimension;
    private static MonitorAttribute autoSize3Attribute;
    private static String autoSize3Value;
    private static Dimension autoSize4Dimension;
    private static MonitorAttribute autoSize4Attribute;
    private static String autoSize4Value;
    private static Dimension autoSize5Dimension;
    private static MonitorAttribute autoSize5Attribute;
    private static String autoSize5Value;
    private static Dimension autoSize6Dimension;
    private static MonitorAttribute autoSize6Attribute;
    private static String autoSize6Value;
    private static Dimension autoSize7Dimension;
    private static MonitorAttribute autoSize7Attribute;
    private static String autoSize7Value;
    private static Dimension autoSize8Dimension;
    private static MonitorAttribute autoSize8Attribute;
    private static String autoSize8Value;
    private static Dimension autoSize9Dimension;
    private static MonitorAttribute autoSize9Attribute;
    private static String autoSize9Value;
    private static Dimension autoSize10Dimension;
    private static MonitorAttribute autoSize10Attribute;
    private static String autoSize10Value;
    private static Dimension hotkey1Dimension;
    private static Keybind hotkey1Key;
    private static Dimension hotkey2Dimension;
    private static Keybind hotkey2Key;
    private static Dimension hotkey3Dimension;
    private static Keybind hotkey3Key;
    private static Dimension hotkey4Dimension;
    private static Keybind hotkey4Key;
    private static Dimension hotkey5Dimension;
    private static Keybind hotkey5Key;
    private static Dimension hotkey6Dimension;
    private static Keybind hotkey6Key;
    private static Dimension hotkey7Dimension;
    private static Keybind hotkey7Key;
    private static Dimension hotkey8Dimension;
    private static Keybind hotkey8Key;
    private static Dimension hotkey9Dimension;
    private static Keybind hotkey9Key;
    private static Dimension hotkey10Dimension;
    private static Keybind hotkey10Key;
    private static boolean resizableScalingAutomatic1;
    private static int resizableScalingAutomatic1Percent;
    private static boolean resizableScalingAutomatic2;
    private static int resizableScalingAutomatic2Percent;
    private static boolean resizableScalingAutomatic3;
    private static int resizableScalingAutomatic3Percent;
    private static boolean resizableScalingAutomatic4;
    private static int resizableScalingAutomatic4Percent;
    private static boolean resizableScalingAutomatic5;
    private static int resizableScalingAutomatic5Percent;
    private static boolean resizableScalingAutomatic6;
    private static int resizableScalingAutomatic6Percent;
    private static boolean resizableScalingAutomatic7;
    private static int resizableScalingAutomatic7Percent;
    private static boolean resizableScalingAutomatic8;
    private static int resizableScalingAutomatic8Percent;
    private static boolean resizableScalingAutomatic9;
    private static int resizableScalingAutomatic9Percent;
    private static boolean resizableScalingAutomatic10;
    private static int resizableScalingAutomatic10Percent;
    private static boolean resizableScalingHotkey1;
    private static int resizableScalingHotkey1Percent;
    private static boolean resizableScalingHotkey2;
    private static int resizableScalingHotkey2Percent;
    private static boolean resizableScalingHotkey3;
    private static int resizableScalingHotkey3Percent;
    private static boolean resizableScalingHotkey4;
    private static int resizableScalingHotkey4Percent;
    private static boolean resizableScalingHotkey5;
    private static int resizableScalingHotkey5Percent;
    private static boolean resizableScalingHotkey6;
    private static int resizableScalingHotkey6Percent;
    private static boolean resizableScalingHotkey7;
    private static int resizableScalingHotkey7Percent;
    private static boolean resizableScalingHotkey8;
    private static int resizableScalingHotkey8Percent;
    private static boolean resizableScalingHotkey9;
    private static int resizableScalingHotkey9Percent;
    private static boolean resizableScalingHotkey10;
    private static int resizableScalingHotkey10Percent;
    private static MonitorAttribute copyAttribute;
    private static GraphicsConfiguration graphicsConfig;
    private static GraphicsDevice currentMonitor;
    private static GraphicsDevice previousMonitor;
    private static GameState currentGameState;
    private static boolean hasProfileChanged;
    private static String previousIDstring;
    private static Rectangle previousBounds;
    private static Dimension previousDimensions;
    private static int previousRefreshRate;
    private static final Pattern numericPattern;
    private static int defaultResizableScaling;
    @Inject
    private Client client;
    @Inject
    private ClientResizerConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientUI clientUI;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ClientThread clientThread;
    private final HotkeyListener hotkeyListener1 = new HotkeyListener(() -> hotkey1Key){

        public boolean isEnabledOnLoginScreen() {
            return true;
        }

        public void hotkeyPressed() {
            ClientResizerPlugin.this.setGameSize(hotkey1Dimension);
            if (resizableScalingHotkey1) {
                ClientResizerPlugin.this.setResizableScaling(resizableScalingHotkey1Percent);
            }
        }

        public void hotkeyReleased() {
        }
    };
    private final HotkeyListener hotkeyListener2 = new HotkeyListener(() -> hotkey2Key){

        public boolean isEnabledOnLoginScreen() {
            return true;
        }

        public void hotkeyPressed() {
            ClientResizerPlugin.this.setGameSize(hotkey2Dimension);
            if (resizableScalingHotkey2) {
                ClientResizerPlugin.this.setResizableScaling(resizableScalingHotkey2Percent);
            }
        }

        public void hotkeyReleased() {
        }
    };
    private final HotkeyListener hotkeyListener3 = new HotkeyListener(() -> hotkey3Key){

        public boolean isEnabledOnLoginScreen() {
            return true;
        }

        public void hotkeyPressed() {
            ClientResizerPlugin.this.setGameSize(hotkey3Dimension);
            if (resizableScalingHotkey3) {
                ClientResizerPlugin.this.setResizableScaling(resizableScalingHotkey3Percent);
            }
        }

        public void hotkeyReleased() {
        }
    };
    private final HotkeyListener hotkeyListener4 = new HotkeyListener(() -> hotkey4Key){

        public boolean isEnabledOnLoginScreen() {
            return true;
        }

        public void hotkeyPressed() {
            ClientResizerPlugin.this.setGameSize(hotkey4Dimension);
            if (resizableScalingHotkey4) {
                ClientResizerPlugin.this.setResizableScaling(resizableScalingHotkey4Percent);
            }
        }

        public void hotkeyReleased() {
        }
    };
    private final HotkeyListener hotkeyListener5 = new HotkeyListener(() -> hotkey5Key){

        public boolean isEnabledOnLoginScreen() {
            return true;
        }

        public void hotkeyPressed() {
            ClientResizerPlugin.this.setGameSize(hotkey5Dimension);
            if (resizableScalingHotkey5) {
                ClientResizerPlugin.this.setResizableScaling(resizableScalingHotkey5Percent);
            }
        }

        public void hotkeyReleased() {
        }
    };
    private final HotkeyListener hotkeyListener6 = new HotkeyListener(() -> hotkey6Key){

        public boolean isEnabledOnLoginScreen() {
            return true;
        }

        public void hotkeyPressed() {
            ClientResizerPlugin.this.setGameSize(hotkey6Dimension);
            if (resizableScalingHotkey6) {
                ClientResizerPlugin.this.setResizableScaling(resizableScalingHotkey6Percent);
            }
        }

        public void hotkeyReleased() {
        }
    };
    private final HotkeyListener hotkeyListener7 = new HotkeyListener(() -> hotkey7Key){

        public boolean isEnabledOnLoginScreen() {
            return true;
        }

        public void hotkeyPressed() {
            ClientResizerPlugin.this.setGameSize(hotkey7Dimension);
            if (resizableScalingHotkey7) {
                ClientResizerPlugin.this.setResizableScaling(resizableScalingHotkey7Percent);
            }
        }

        public void hotkeyReleased() {
        }
    };
    private final HotkeyListener hotkeyListener8 = new HotkeyListener(() -> hotkey8Key){

        public boolean isEnabledOnLoginScreen() {
            return true;
        }

        public void hotkeyPressed() {
            ClientResizerPlugin.this.setGameSize(hotkey8Dimension);
            if (resizableScalingHotkey8) {
                ClientResizerPlugin.this.setResizableScaling(resizableScalingHotkey8Percent);
            }
        }

        public void hotkeyReleased() {
        }
    };
    private final HotkeyListener hotkeyListener9 = new HotkeyListener(() -> hotkey9Key){

        public boolean isEnabledOnLoginScreen() {
            return true;
        }

        public void hotkeyPressed() {
            ClientResizerPlugin.this.setGameSize(hotkey9Dimension);
            if (resizableScalingHotkey9) {
                ClientResizerPlugin.this.setResizableScaling(resizableScalingHotkey9Percent);
            }
        }

        public void hotkeyReleased() {
        }
    };
    private final HotkeyListener hotkeyListener10 = new HotkeyListener(() -> hotkey10Key){

        public boolean isEnabledOnLoginScreen() {
            return true;
        }

        public void hotkeyPressed() {
            ClientResizerPlugin.this.setGameSize(hotkey10Dimension);
            if (resizableScalingHotkey10) {
                ClientResizerPlugin.this.setResizableScaling(resizableScalingHotkey10Percent);
            }
        }

        public void hotkeyReleased() {
        }
    };

    public void startUp() throws Exception {
        defaultResizableScaling = (Integer)this.configManager.getConfiguration("stretchedmode", "scalingFactor", Integer.class);
        this.updateConfig();
        this.setDefaultDimensions();
        this.registerHotkeyListeners();
    }

    public void shutDown() throws Exception {
        this.unregisterHotkeyListeners();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("ClientResizer")) {
            this.updateConfig();
            if (configChanged.getKey().equals("copyAttribute")) {
                this.copyAttributeToClipboard();
            }
        }
    }

    private void updateConfig() {
        resizeAttributeUnchanged = this.config.resizeAttributeUnchanged();
        resizeWhenConfigProfileChanged = this.config.resizeWhenConfigProfileChanged();
        autoSize1Dimension = this.config.autoSize1Dimension();
        autoSize1Attribute = this.config.autoSize1Attribute();
        autoSize1Value = this.config.autoSize1Value();
        autoSize2Dimension = this.config.autoSize2Dimension();
        autoSize2Attribute = this.config.autoSize2Attribute();
        autoSize2Value = this.config.autoSize2Value();
        autoSize3Dimension = this.config.autoSize3Dimension();
        autoSize3Attribute = this.config.autoSize3Attribute();
        autoSize3Value = this.config.autoSize3Value();
        autoSize4Dimension = this.config.autoSize4Dimension();
        autoSize4Attribute = this.config.autoSize4Attribute();
        autoSize4Value = this.config.autoSize4Value();
        autoSize5Dimension = this.config.autoSize5Dimension();
        autoSize5Attribute = this.config.autoSize5Attribute();
        autoSize5Value = this.config.autoSize5Value();
        autoSize6Dimension = this.config.autoSize6Dimension();
        autoSize6Attribute = this.config.autoSize6Attribute();
        autoSize6Value = this.config.autoSize6Value();
        autoSize7Dimension = this.config.autoSize7Dimension();
        autoSize7Attribute = this.config.autoSize7Attribute();
        autoSize7Value = this.config.autoSize7Value();
        autoSize8Dimension = this.config.autoSize8Dimension();
        autoSize8Attribute = this.config.autoSize8Attribute();
        autoSize8Value = this.config.autoSize8Value();
        autoSize9Dimension = this.config.autoSize9Dimension();
        autoSize9Attribute = this.config.autoSize9Attribute();
        autoSize9Value = this.config.autoSize9Value();
        autoSize10Dimension = this.config.autoSize10Dimension();
        autoSize10Attribute = this.config.autoSize10Attribute();
        autoSize10Value = this.config.autoSize10Value();
        hotkey1Dimension = this.config.hotkey1Dimension();
        hotkey1Key = this.config.hotkey1Key();
        hotkey2Dimension = this.config.hotkey2Dimension();
        hotkey2Key = this.config.hotkey2Key();
        hotkey3Dimension = this.config.hotkey3Dimension();
        hotkey3Key = this.config.hotkey3Key();
        hotkey4Dimension = this.config.hotkey4Dimension();
        hotkey4Key = this.config.hotkey4Key();
        hotkey5Dimension = this.config.hotkey5Dimension();
        hotkey5Key = this.config.hotkey5Key();
        hotkey6Dimension = this.config.hotkey6Dimension();
        hotkey6Key = this.config.hotkey6Key();
        hotkey7Dimension = this.config.hotkey7Dimension();
        hotkey7Key = this.config.hotkey7Key();
        hotkey8Dimension = this.config.hotkey8Dimension();
        hotkey8Key = this.config.hotkey8Key();
        hotkey9Dimension = this.config.hotkey9Dimension();
        hotkey9Key = this.config.hotkey9Key();
        hotkey10Dimension = this.config.hotkey10Dimension();
        hotkey10Key = this.config.hotkey10Key();
        resizableScalingAutomatic1 = this.config.resizableScalingAutomatic1();
        resizableScalingAutomatic1Percent = this.config.resizableScalingAutomatic1Percent();
        resizableScalingAutomatic2 = this.config.resizableScalingAutomatic2();
        resizableScalingAutomatic2Percent = this.config.resizableScalingAutomatic2Percent();
        resizableScalingAutomatic3 = this.config.resizableScalingAutomatic3();
        resizableScalingAutomatic3Percent = this.config.resizableScalingAutomatic3Percent();
        resizableScalingAutomatic4 = this.config.resizableScalingAutomatic4();
        resizableScalingAutomatic4Percent = this.config.resizableScalingAutomatic4Percent();
        resizableScalingAutomatic5 = this.config.resizableScalingAutomatic5();
        resizableScalingAutomatic5Percent = this.config.resizableScalingAutomatic5Percent();
        resizableScalingAutomatic6 = this.config.resizableScalingAutomatic6();
        resizableScalingAutomatic6Percent = this.config.resizableScalingAutomatic6Percent();
        resizableScalingAutomatic7 = this.config.resizableScalingAutomatic7();
        resizableScalingAutomatic7Percent = this.config.resizableScalingAutomatic7Percent();
        resizableScalingAutomatic8 = this.config.resizableScalingAutomatic8();
        resizableScalingAutomatic8Percent = this.config.resizableScalingAutomatic8Percent();
        resizableScalingAutomatic9 = this.config.resizableScalingAutomatic9();
        resizableScalingAutomatic9Percent = this.config.resizableScalingAutomatic9Percent();
        resizableScalingAutomatic10 = this.config.resizableScalingAutomatic10();
        resizableScalingAutomatic10Percent = this.config.resizableScalingAutomatic10Percent();
        resizableScalingHotkey1 = this.config.resizableScalingHotkey1();
        resizableScalingHotkey1Percent = this.config.resizableScalingHotkey1Percent();
        resizableScalingHotkey2 = this.config.resizableScalingHotkey2();
        resizableScalingHotkey2Percent = this.config.resizableScalingHotkey2Percent();
        resizableScalingHotkey3 = this.config.resizableScalingHotkey3();
        resizableScalingHotkey3Percent = this.config.resizableScalingHotkey3Percent();
        resizableScalingHotkey4 = this.config.resizableScalingHotkey4();
        resizableScalingHotkey4Percent = this.config.resizableScalingHotkey4Percent();
        resizableScalingHotkey5 = this.config.resizableScalingHotkey5();
        resizableScalingHotkey5Percent = this.config.resizableScalingHotkey5Percent();
        resizableScalingHotkey6 = this.config.resizableScalingHotkey6();
        resizableScalingHotkey6Percent = this.config.resizableScalingHotkey6Percent();
        resizableScalingHotkey7 = this.config.resizableScalingHotkey7();
        resizableScalingHotkey7Percent = this.config.resizableScalingHotkey7Percent();
        resizableScalingHotkey8 = this.config.resizableScalingHotkey8();
        resizableScalingHotkey8Percent = this.config.resizableScalingHotkey8Percent();
        resizableScalingHotkey9 = this.config.resizableScalingHotkey9();
        resizableScalingHotkey9Percent = this.config.resizableScalingHotkey9Percent();
        resizableScalingHotkey10 = this.config.resizableScalingHotkey10();
        resizableScalingHotkey10Percent = this.config.resizableScalingHotkey10Percent();
        copyAttribute = this.config.copyAttribute();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        currentGameState = gameStateChanged.getGameState();
    }

    @Subscribe
    public void onBeforeRender(BeforeRender beforeRender) {
        if (currentGameState != GameState.LOGGED_IN && currentGameState != GameState.UNKNOWN && currentGameState != GameState.STARTING) {
            this.monitorCheck();
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        this.monitorCheck();
    }

    @Subscribe
    public void onProfileChanged(ProfileChanged profileChanged) {
        this.updateConfig();
        if (resizeWhenConfigProfileChanged) {
            hasProfileChanged = true;
            this.resizeClient();
        }
    }

    private void setDefaultDimensions() {
        Dimension[] DimensionsArray = new Dimension[]{autoSize1Dimension, autoSize2Dimension, autoSize3Dimension, autoSize4Dimension, autoSize5Dimension, autoSize6Dimension, autoSize7Dimension, autoSize8Dimension, autoSize9Dimension, autoSize10Dimension, hotkey1Dimension, hotkey2Dimension, hotkey3Dimension, hotkey4Dimension, hotkey5Dimension, hotkey6Dimension, hotkey7Dimension, hotkey8Dimension, hotkey9Dimension, hotkey10Dimension};
        String[] DimensionsStringArray = new String[]{"autoSize1Dimension", "autoSize2Dimension", "autoSize3Dimension", "autoSize4Dimension", "autoSize5Dimension", "autoSize6Dimension", "autoSize7Dimension", "autoSize8Dimension", "autoSize9Dimension", "autoSize10Dimension", "hotkey1Dimension", "hotkey2Dimension", "hotkey3Dimension", "hotkey4Dimension", "hotkey5Dimension", "hotkey6Dimension", "hotkey7Dimension", "hotkey8Dimension", "hotkey9Dimension", "hotkey10Dimension"};
        for (int i = 0; i < DimensionsArray.length; ++i) {
            this.setDefaultDimension(DimensionsArray[i], DimensionsStringArray[i]);
        }
        this.configManager.setConfiguration("ClientResizer", "copyAttribute", (Object)MonitorAttribute.Disabled);
        this.updateConfig();
    }

    private void setDefaultDimension(Dimension dimension, String dimensionName) {
        Dimension defaultDimension = new Dimension(0, 0);
        if (dimension.equals(defaultDimension)) {
            Dimension currentSize = (Dimension)this.configManager.getConfiguration("runelite", "gameSize", Dimension.class);
            this.configManager.setConfiguration("ClientResizer", dimensionName, (Object)currentSize);
        }
    }

    private void copyAttributeToClipboard() {
        if (copyAttribute != MonitorAttribute.Disabled && this.currentMonitorValueForAttribute(copyAttribute) != null) {
            String valueToCopy = this.currentMonitorValueForAttribute(copyAttribute).toString();
            if (copyAttribute == MonitorAttribute.Bounds) {
                valueToCopy = valueToCopy.replace("java.awt.Rectangle[", "").replace("]", "");
            }
            if (copyAttribute == MonitorAttribute.Dimensions) {
                valueToCopy = valueToCopy.replace("java.awt.Dimension[", "").replace("]", "");
            }
            StringSelection stringSelection = new StringSelection(valueToCopy);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    private void monitorCheck() {
        graphicsConfig = this.clientUI.getGraphicsConfiguration();
        currentMonitor = graphicsConfig.getDevice();
        if (this.hasMonitorChanged()) {
            this.copyAttributeToClipboard();
            this.resizeClient();
        }
    }

    private boolean hasMonitorChanged() {
        if (!currentMonitor.equals(previousMonitor)) {
            previousMonitor = currentMonitor;
            return true;
        }
        previousMonitor = currentMonitor;
        return false;
    }

    private Object currentMonitorValueForAttribute(MonitorAttribute attributeType) {
        switch (attributeType) {
            case IDstring: {
                return currentMonitor.getIDstring();
            }
            case Bounds: {
                return graphicsConfig.getBounds();
            }
            case Dimensions: {
                return new Dimension(currentMonitor.getDisplayMode().getWidth(), currentMonitor.getDisplayMode().getHeight());
            }
            case RefreshRate: {
                return currentMonitor.getDisplayMode().getRefreshRate();
            }
        }
        return null;
    }

    private void resizeClient() {
        MonitorAttribute[] AttributesArray = new MonitorAttribute[]{autoSize1Attribute, autoSize2Attribute, autoSize3Attribute, autoSize4Attribute, autoSize5Attribute, autoSize6Attribute, autoSize7Attribute, autoSize8Attribute, autoSize9Attribute, autoSize10Attribute};
        String[] ValuesStringArray = new String[]{autoSize1Value, autoSize2Value, autoSize3Value, autoSize4Value, autoSize5Value, autoSize6Value, autoSize7Value, autoSize8Value, autoSize9Value, autoSize10Value};
        Dimension[] DimensionsArray = new Dimension[]{autoSize1Dimension, autoSize2Dimension, autoSize3Dimension, autoSize4Dimension, autoSize5Dimension, autoSize6Dimension, autoSize7Dimension, autoSize8Dimension, autoSize9Dimension, autoSize10Dimension};
        Boolean[] resizableScalingBoolArray = new Boolean[]{resizableScalingAutomatic1, resizableScalingAutomatic2, resizableScalingAutomatic3, resizableScalingAutomatic4, resizableScalingAutomatic5, resizableScalingAutomatic6, resizableScalingAutomatic7, resizableScalingAutomatic8, resizableScalingAutomatic9, resizableScalingAutomatic10};
        Integer[] resizableScalingPercentArray = new Integer[]{resizableScalingAutomatic1Percent, resizableScalingAutomatic2Percent, resizableScalingAutomatic3Percent, resizableScalingAutomatic4Percent, resizableScalingAutomatic5Percent, resizableScalingAutomatic6Percent, resizableScalingAutomatic7Percent, resizableScalingAutomatic8Percent, resizableScalingAutomatic9Percent, resizableScalingAutomatic10Percent};
        for (int i = 0; i < AttributesArray.length; ++i) {
            if (AttributesArray[i] == MonitorAttribute.Disabled || this.processAttributeString(AttributesArray[i], ValuesStringArray[i]) == null || !this.processAttributeString(AttributesArray[i], ValuesStringArray[i]).equals(this.currentMonitorValueForAttribute(AttributesArray[i]))) continue;
            if (resizeAttributeUnchanged) {
                this.setGameSize(DimensionsArray[i]);
                if (resizableScalingBoolArray[i].booleanValue()) {
                    this.setResizableScaling(resizableScalingPercentArray[i]);
                }
            }
            if (resizeAttributeUnchanged || !this.hasAttributeChanged(AttributesArray[i]) && !hasProfileChanged) continue;
            this.setGameSize(DimensionsArray[i]);
            if (!resizableScalingBoolArray[i].booleanValue()) continue;
            this.setResizableScaling(resizableScalingPercentArray[i]);
        }
        hasProfileChanged = false;
        this.updatePreviousAttributes();
    }

    private Object processAttributeString(MonitorAttribute attributeType, String attributeString) {
        if (attributeString != null && !attributeString.isEmpty() && attributeType != MonitorAttribute.Disabled) {
            attributeString = attributeString.replaceAll("\\s+", "");
            switch (attributeType) {
                case IDstring: {
                    return attributeString;
                }
                case Bounds: {
                    String[] splitAttributeBoundsString = attributeString.split(",");
                    if (splitAttributeBoundsString.length != 4) break;
                    String xBounds = splitAttributeBoundsString[0].replace("x=", "").replace("y=", "").replace("width=", "").replace("height=", "");
                    String yBounds = splitAttributeBoundsString[1].replace("x=", "").replace("y=", "").replace("width=", "").replace("height=", "");
                    String widthBounds = splitAttributeBoundsString[2].replace("x=", "").replace("y=", "").replace("width=", "").replace("height=", "");
                    String heightBounds = splitAttributeBoundsString[3].replace("x=", "").replace("y=", "").replace("width=", "").replace("height=", "");
                    if (!this.isNumeric(xBounds) || !this.isNumeric(yBounds) || !this.isNumeric(widthBounds) || !this.isNumeric(heightBounds)) break;
                    return new Rectangle(Integer.parseInt(xBounds), Integer.parseInt(yBounds), Integer.parseInt(widthBounds), Integer.parseInt(heightBounds));
                }
                case Dimensions: {
                    String[] splitAttributeDimensionsString = attributeString.split(",");
                    if (splitAttributeDimensionsString.length != 2) break;
                    String widthDimensions = splitAttributeDimensionsString[0].replace("width=", "").replace("height=", "");
                    String heightDimensions = splitAttributeDimensionsString[1].replace("width=", "").replace("height=", "");
                    if (!this.isNumeric(widthDimensions) || !this.isNumeric(heightDimensions)) break;
                    return new Dimension(Integer.parseInt(widthDimensions), Integer.parseInt(heightDimensions));
                }
                case RefreshRate: {
                    if (!this.isNumeric(attributeString)) break;
                    return Integer.parseInt(attributeString);
                }
            }
        }
        return null;
    }

    private boolean isNumeric(String inputString) {
        if (inputString == null) {
            return false;
        }
        return numericPattern.matcher(inputString).matches();
    }

    private void setGameSize(Dimension dimension) {
        int processedWidth = Math.max(Math.min(dimension.width, 7680), 765);
        int processedHeight = Math.max(Math.min(dimension.height, 2160), 503);
        Dimension processedGameSize = new Dimension(processedWidth, processedHeight);
        Dimension currentSize = (Dimension)this.configManager.getConfiguration("runelite", "gameSize", Dimension.class);
        if (!currentSize.equals(processedGameSize)) {
            this.configManager.setConfiguration("runelite", "gameSize", (Object)processedGameSize);
            this.clientThread.invokeLater(() -> this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Your RuneLite game size / client size was changed by the Client Resizer plugin. Check your config if you'd like to change this.", ""));
        }
    }

    private void setResizableScaling(int resizableScalingPercent) {
        int currentResizableScalingPercent = (Integer)this.configManager.getConfiguration("stretchedmode", "scalingFactor", Integer.class);
        if (currentResizableScalingPercent != resizableScalingPercent) {
            this.configManager.setConfiguration("stretchedmode", "scalingFactor", (Object)resizableScalingPercent);
            this.clientThread.invokeLater(() -> this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Your resizable scaling (stretched mode plugin) was changed by the Client Resizer plugin. Check your config if you'd like to change this.", ""));
        }
    }

    private boolean hasAttributeChanged(MonitorAttribute inputAttribute) {
        return this.previousAttributeValue(inputAttribute) == null || !this.previousAttributeValue(inputAttribute).equals(this.currentMonitorValueForAttribute(inputAttribute));
    }

    private Object previousAttributeValue(MonitorAttribute inputAttribute) {
        switch (inputAttribute) {
            case IDstring: {
                return previousIDstring;
            }
            case Bounds: {
                return previousBounds;
            }
            case Dimensions: {
                return previousDimensions;
            }
            case RefreshRate: {
                return previousRefreshRate;
            }
        }
        return null;
    }

    private void updatePreviousAttributes() {
        previousIDstring = (String)this.currentMonitorValueForAttribute(MonitorAttribute.IDstring);
        previousBounds = (Rectangle)this.currentMonitorValueForAttribute(MonitorAttribute.Bounds);
        previousDimensions = (Dimension)this.currentMonitorValueForAttribute(MonitorAttribute.Dimensions);
        previousRefreshRate = (Integer)this.currentMonitorValueForAttribute(MonitorAttribute.RefreshRate);
    }

    private void registerHotkeyListeners() {
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener1);
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener2);
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener3);
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener4);
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener5);
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener6);
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener7);
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener8);
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener9);
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener10);
    }

    private void unregisterHotkeyListeners() {
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener1);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener2);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener3);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener4);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener5);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener6);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener7);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener8);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener9);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener10);
    }

    @Provides
    ClientResizerConfig provideConfig(ConfigManager configManager) {
        return (ClientResizerConfig)configManager.getConfig(ClientResizerConfig.class);
    }

    public static int getDefaultResizableScaling() {
        return defaultResizableScaling;
    }

    static {
        numericPattern = Pattern.compile("-?\\d+(\\.\\d+)?");
        defaultResizableScaling = 50;
    }
}

