/*
 * Decompiled with CFR 0.152.
 */
package com.undyingretributiontimer;

import com.undyingretributiontimer.UndyingRetributionTimerConfig;
import com.undyingretributiontimer.UndyingRetributionTimerPlugin;
import java.awt.Color;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxPriority;

public class UndyingRetributionTimerInfoBox
extends InfoBox {
    private final UndyingRetributionTimerPlugin plugin;
    private final UndyingRetributionTimerConfig config;

    @Inject
    public UndyingRetributionTimerInfoBox(UndyingRetributionTimerPlugin plugin, UndyingRetributionTimerConfig config) {
        super(null, (Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
        this.setPriority(InfoBoxPriority.MED);
    }

    public String getText() {
        if (!this.plugin.onCooldown && this.plugin.remainingTicks == 0) {
            return "";
        }
        if (this.plugin.remainingTicks < 0) {
            return "?";
        }
        String str = this.config.displayMode() == UndyingRetributionTimerConfig.DisplayMode.TICKS ? String.valueOf(this.plugin.remainingTicks) : (this.config.displayMode() == UndyingRetributionTimerConfig.DisplayMode.DECIMALS ? UndyingRetributionTimerPlugin.to_mmss_precise_short(this.plugin.remainingTicks) : UndyingRetributionTimerPlugin.to_mmss(this.plugin.remainingTicks));
        return str;
    }

    public Color getTextColor() {
        if (this.plugin.remainingTicks == -1) {
            return Color.CYAN;
        }
        return this.config.textColor();
    }

    public String getTooltip() {
        return "Undying Retribution";
    }
}

