/*
 * Decompiled with CFR 0.152.
 */
package com.undyingretributiontimer;

public enum RaidRoom {
    NEXUS(new int[]{14160}, "Nexus", RaidRoomType.LOBBY),
    CRONDIS(new int[]{15698}, "Crondis", RaidRoomType.PUZZLE),
    ZEBAK(new int[]{15700}, "Zebak", RaidRoomType.BOSS),
    SCABARAS(new int[]{14162}, "Scabaras", RaidRoomType.PUZZLE),
    KEPHRI(new int[]{14164}, "Kephri", RaidRoomType.BOSS),
    APMEKEN(new int[]{15186}, "Apmeken", RaidRoomType.PUZZLE),
    BABA(new int[]{15188}, "Ba-Ba", RaidRoomType.BOSS),
    HET(new int[]{14674}, "Het", RaidRoomType.PUZZLE),
    AKKHA(new int[]{14676}, "Akkha", RaidRoomType.BOSS),
    WARDENS(new int[]{15184, 15696}, "Wardens", RaidRoomType.BOSS),
    TOMB(new int[]{14672}, "Tomb", RaidRoomType.LOBBY);

    private final int[] regionIds;
    private final String displayName;
    private final RaidRoomType roomType;

    public static RaidRoom forRegionId(int region) {
        for (RaidRoom r : RaidRoom.values()) {
            for (int regionId : r.regionIds) {
                if (regionId != region) continue;
                return r;
            }
        }
        return null;
    }

    public static RaidRoom forString(String roomName) {
        for (RaidRoom r : RaidRoom.values()) {
            if (!r.getDisplayName().equals(roomName)) continue;
            return r;
        }
        return null;
    }

    public String toString() {
        return this.displayName;
    }

    private RaidRoom(int[] regionIds, String displayName, RaidRoomType roomType) {
        this.regionIds = regionIds;
        this.displayName = displayName;
        this.roomType = roomType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public RaidRoomType getRoomType() {
        return this.roomType;
    }

    public static enum RaidRoomType {
        LOBBY,
        PUZZLE,
        BOSS;

    }
}

