/*
 * Decompiled with CFR 0.152.
 */
package com.methodtournamentclient;

import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.inject.Provides;
import com.methodtournamentclient.TournamentConfig;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.HeadIcon;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Method Tournament", enabledByDefault=false, description="Sends information from your client to a database, to be displayed on stream")
public class TournamentPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TournamentPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private TournamentConfig config;
    @Inject
    private ItemManager itemManager;
    private OkHttpClient okClient = new OkHttpClient();
    private Player opponent;
    ItemContainer itemContainer = null;
    List<Integer> itemList = new ArrayList<Integer>();
    StopWatch watch = new StopWatch();
    private String inventSend;
    private int badResponses = 0;
    private int onPrayHits = 0;
    private int offPrayHits = 0;
    private int damageReceived = 0;
    private int damageDealt = 0;
    private final List<Integer> MELEE_ATTACKS = Arrays.asList(376, 381, 386, 390, 393, 393, 395, 400, 401, 406, 407, 414, 419, 422, 423, 428, 429, 440, 1058, 1060, 1062, 1378, 1658, 1665, 1667, 2066, 2067, 2078, 2661, 3297, 3298, 3852, 5865, 7004, 7045, 7054, 7514, 7515, 7516, 7638, 7639, 7640, 7641, 7642, 7643, 7644, 7645, 8056, 8145);
    private final List<Integer> RANGE_ATTACKS = Arrays.asList(426, 929, 1074, 4230, 5061, 6600, 7218, 7521, 7552, 7555, 7617, 8194, 8195, 8292);
    private final List<Integer> MAGE_ATTACKS = Arrays.asList(710, 711, 1161, 1162, 1167, 7855, 1978, 1979, 8532);
    private final WorldArea DUEL_ARENA = new WorldArea(3333, 3244, 25, 15, 0);

    @Provides
    TournamentConfig provideConfig(ConfigManager configManager) {
        return (TournamentConfig)configManager.getConfig(TournamentConfig.class);
    }

    protected void startUp() throws Exception {
        this.itemContainer = null;
        this.itemList.clear();
        this.badResponses = 0;
        this.opponent = null;
        this.inventSend = "";
        this.onPrayHits = 0;
        this.offPrayHits = 0;
        this.damageReceived = 0;
        this.damageDealt = 0;
        if (this.watch.isStarted()) {
            this.watch.stop();
        }
    }

    protected void shutDown() throws Exception {
        this.itemContainer = null;
        this.itemList.clear();
        this.badResponses = 0;
        this.opponent = null;
        this.inventSend = "";
        this.onPrayHits = 0;
        this.offPrayHits = 0;
        this.damageReceived = 0;
        this.damageDealt = 0;
        if (this.watch.isStarted()) {
            this.watch.stop();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("tournament")) {
            return;
        }
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted event) {
        if (event.getCommand().equals("test")) {
            this.test();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getGameState() == GameState.LOGIN_SCREEN || this.badResponses > 10) {
            return;
        }
        if (this.client.getLocalPlayer() == null || this.opponent == null) {
            return;
        }
        if (!this.client.getLocalPlayer().getWorldArea().intersectsWith(this.DUEL_ARENA)) {
            this.resetValues();
            return;
        }
        if (this.config.enable()) {
            this.sendPostRequest(this.inventSend, this.client.getLocalPlayer().getName(), false);
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (!this.config.enable() || this.client.getGameState() == GameState.LOGIN_SCREEN || this.badResponses > 10) {
            return;
        }
        ItemContainer container = event.getItemContainer();
        if (container == this.client.getItemContainer(InventoryID.INVENTORY)) {
            this.captureInvent();
            if (TournamentPlugin.isValidUrl(this.config.endpoint()) && this.config.enable() && !this.client.getLocalPlayer().getWorldArea().intersectsWith(this.DUEL_ARENA)) {
                this.sendPostRequest(this.inventSend, this.client.getLocalPlayer().getName(), false);
            }
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        this.clientThread.invokeLater(() -> {
            if (this.client.getLocalPlayer() == null || this.opponent == null) {
                return;
            }
            Player local = this.client.getLocalPlayer();
            if (event.getActor().equals(local)) {
                if (this.MELEE_ATTACKS.contains(event.getActor().getAnimation())) {
                    if (this.opponent.getOverheadIcon() != null && this.opponent.getOverheadIcon().equals((Object)HeadIcon.MELEE)) {
                        ++this.onPrayHits;
                    } else {
                        ++this.offPrayHits;
                    }
                }
                if (this.RANGE_ATTACKS.contains(event.getActor().getAnimation())) {
                    if (this.opponent.getOverheadIcon() != null && this.opponent.getOverheadIcon().equals((Object)HeadIcon.RANGED)) {
                        ++this.onPrayHits;
                    } else {
                        ++this.offPrayHits;
                    }
                }
                if (this.MAGE_ATTACKS.contains(event.getActor().getAnimation())) {
                    if (this.opponent.getOverheadIcon() != null && this.opponent.getOverheadIcon().equals((Object)HeadIcon.MAGIC)) {
                        ++this.onPrayHits;
                    } else {
                        ++this.offPrayHits;
                    }
                }
            }
        });
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        if (this.client.getLocalPlayer() == null || this.opponent == null) {
            return;
        }
        if (this.client.getLocalPlayer().getWorldArea().intersectsWith(this.DUEL_ARENA)) {
            if (event.getActor().equals(this.client.getLocalPlayer())) {
                this.damageReceived += event.getHitsplat().getAmount();
            }
            if (event.getActor().equals(this.opponent)) {
                this.damageDealt += event.getHitsplat().getAmount();
            }
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged event) {
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        if (this.client.getLocalPlayer().getWorldArea().intersectsWith(this.DUEL_ARENA)) {
            if (event.getSource() == this.client.getLocalPlayer()) {
                Actor target = event.getTarget();
                if (target == this.opponent) {
                    return;
                }
                if (this.opponent == null && target instanceof Player) {
                    this.resetValues();
                    this.opponent = (Player)target;
                    if (this.config.debug()) {
                        this.clientThread.invokeLater(() -> this.client.addChatMessage(ChatMessageType.ENGINE, "", "Opponent set: " + this.opponent.getName(), ""));
                    }
                }
                return;
            }
            if (event.getTarget() instanceof Player && event.getSource() != this.client.getLocalPlayer() && event.getTarget().equals(this.client.getLocalPlayer()) && event.getSource().getWorldArea().intersectsWith(this.DUEL_ARENA)) {
                Actor target = event.getTarget();
                Actor source = event.getSource();
                if (target.equals(this.client.getLocalPlayer())) {
                    if (source == this.opponent) {
                        return;
                    }
                    if (this.opponent == null && source instanceof Player) {
                        this.resetValues();
                        this.opponent = (Player)source;
                        if (this.config.debug()) {
                            this.clientThread.invokeLater(() -> this.client.addChatMessage(ChatMessageType.ENGINE, "", "Opponent set: " + this.opponent.getName(), ""));
                        }
                    }
                }
            }
        }
    }

    public void resetValues() {
        if (this.config.debug() && this.opponent != null) {
            this.clientThread.invokeLater(() -> this.client.addChatMessage(ChatMessageType.ENGINE, "", "Opponent reset", ""));
        }
        this.opponent = null;
        this.badResponses = 0;
        this.onPrayHits = 0;
        this.offPrayHits = 0;
        this.damageReceived = 0;
        this.damageDealt = 0;
        this.itemContainer = null;
        this.itemList.clear();
    }

    private int getMaxHp() {
        if (this.client.getLocalPlayer() == null) {
            return 99;
        }
        return this.client.getRealSkillLevel(Skill.HITPOINTS);
    }

    private int getCurrentHp() {
        if (this.client.getLocalPlayer() == null) {
            return 99;
        }
        return this.client.getBoostedSkillLevel(Skill.HITPOINTS);
    }

    private int getTotalHits() {
        return this.onPrayHits + this.offPrayHits;
    }

    private String getPrayPercent() {
        double result = (double)this.offPrayHits / (double)this.getTotalHits() * 100.0;
        int toPrint = (int)result;
        return toPrint + "%";
    }

    private String getPrayers() {
        String output = this.offPrayHits + " / " + this.getTotalHits() + "(" + this.getPrayPercent() + ")";
        return output;
    }

    private String getDamage() {
        String posneg = this.damageDealt > this.damageReceived ? "+" : "";
        String output = this.damageDealt + "(" + posneg + (this.damageDealt - this.damageReceived) + ")";
        return output;
    }

    private void captureInvent() {
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer == null) {
            if (this.config.debug()) {
                log.info("Local player null");
            }
            return;
        }
        this.itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (this.itemContainer == null) {
            if (this.config.debug()) {
                log.info("Inventory null");
            }
            return;
        }
        Item[] items = this.itemContainer.getItems();
        this.itemList.clear();
        for (Item item : items) {
            this.itemList.add(item.getId());
        }
        this.inventSend = this.itemList.toString();
    }

    private void test() {
        if (this.client.getLocalPlayer() == null) {
            this.clientThread.invokeLater(() -> this.client.addChatMessage(ChatMessageType.ENGINE, "", "Test: Local Player null, cancelling test", ""));
        }
        this.badResponses = 0;
        if (this.config.endpoint().equals("")) {
            this.clientThread.invokeLater(() -> this.client.addChatMessage(ChatMessageType.ENGINE, "", "Test: Endpoint empty, please enter the endpoint provided to you, in the config", ""));
            return;
        }
        if (this.config.password().equals("")) {
            this.clientThread.invokeLater(() -> this.client.addChatMessage(ChatMessageType.ENGINE, "", "Test: Password empty, please enter the tournament password provided to you, in the config", ""));
            return;
        }
        if (!TournamentPlugin.isValidUrl(this.config.endpoint())) {
            this.clientThread.invokeLater(() -> this.client.addChatMessage(ChatMessageType.ENGINE, "", "Test: Endpoint is not a valid URL", ""));
            return;
        }
        if (this.client.getLocalPlayer().getName() != null) {
            Random r = new Random();
            String inventSend = "[22840, 22840, 22840, 22840, 22840, 22840, 22840, 22840, 22840, 22840, " + r.nextInt(25519) + "]";
            this.sendPostRequest(inventSend, this.client.getLocalPlayer().getName(), true);
        }
    }

    private void sendPostRequest(String inventSend, String user, final Boolean test) {
        HttpUrl url = HttpUrl.parse((String)this.config.endpoint());
        JsonObject jsonObject = new JsonObject();
        try {
            jsonObject.addProperty("user", user);
            jsonObject.addProperty("pass", this.config.password());
            jsonObject.addProperty("invent", inventSend);
            jsonObject.addProperty("currenthp", (Number)this.getCurrentHp());
            jsonObject.addProperty("maxhp", (Number)this.getMaxHp());
            jsonObject.addProperty("prayers", this.getPrayers());
            jsonObject.addProperty("damage", this.getDamage());
        }
        catch (JsonIOException e) {
            e.printStackTrace();
        }
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)JSON, (String)jsonObject.toString());
        Request request = new Request.Builder().url(url).post(body).build();
        this.watch.reset();
        this.watch.start();
        this.okClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.warn("Failure");
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (test.booleanValue()) {
                    TournamentPlugin.this.handleTestResponse(response);
                }
                if (!test.booleanValue()) {
                    TournamentPlugin.this.handleResponse(response);
                }
                response.close();
            }
        });
    }

    private void handleResponse(Response response) throws IOException {
        if (this.watch.isStarted()) {
            this.watch.stop();
        }
        String content = response.body().string();
        long time = this.watch.getTime(TimeUnit.MILLISECONDS);
        if (content == null) {
            if (this.config.debug()) {
                log.info(time + "ms -Null Http response");
                ++this.badResponses;
            }
            return;
        }
        if (content.isEmpty()) {
            if (this.config.debug()) {
                log.info(time + "ms -Empty body Http response");
                ++this.badResponses;
            }
            return;
        }
        if (content.contains("Internal server error")) {
            if (this.config.debug()) {
                log.info(time + "ms - Bad response, internal server error");
                ++this.badResponses;
            }
            return;
        }
        if (content.equals("UNKNOWN_PLAYER")) {
            if (this.config.debug()) {
                log.info(time + "ms -Bad http request: Unknown player");
                ++this.badResponses;
            }
            return;
        }
        if (content.equals("NO_CHANGE")) {
            if (this.config.debug()) {
                log.info(time + "ms -Http request: No Database change, variables didn't change or player not in database");
            }
            return;
        }
        if (content.equals("UPDATE_SUCCESS") && this.config.debug()) {
            log.info(time + "ms -SUCCESS: Database updated");
            return;
        }
        if (this.config.debug()) {
            log.info(time + "ms -Exception, seek help");
        }
    }

    private void handleTestResponse(Response response) throws IOException {
        String content = response.body().string();
        log.info(content);
        Object output = "";
        if (this.watch.isStarted()) {
            this.watch.stop();
        }
        long time = this.watch.getTime(TimeUnit.MILLISECONDS);
        if (content == null || content.isEmpty()) {
            output = (String)output + time + "ms -FAILURE: Http response body empty";
        }
        if (content != null) {
            if (content.contains("Internal server error")) {
                output = (String)output + time + "ms - FAILURE: Internal server error";
            }
            if (content.equals("NO_CHANGE")) {
                output = (String)output + time + "ms -FAILURE: No database change, ";
            }
            if (content.equals("UNAUTHORISED")) {
                output = (String)output + time + "ms -FAILURE: Invalid Password";
            }
            if (content.equals("UPDATE_SUCCESS")) {
                output = (String)output + time + "ms -SUCCESS: Connection completed with good response from server";
            }
        }
        Object finalOutput = output;
        this.clientThread.invokeLater(() -> this.lambda$handleTestResponse$8((String)finalOutput));
    }

    public static boolean isValidUrl(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private /* synthetic */ void lambda$handleTestResponse$8(String finalOutput) {
        this.client.addChatMessage(ChatMessageType.ENGINE, "", "Test: " + finalOutput, "");
    }
}

