/*
 * Decompiled with CFR 0.152.
 */
package com.tobinfoboxes;

import com.google.inject.Provides;
import com.tobinfoboxes.TobInfobox;
import com.tobinfoboxes.TobInfoboxesConfig;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ToB Infoboxes", description="Theatre of Blood room timer infoboxes", tags={"raid", "tob", "timer", "infobox"}, enabledByDefault=false)
public class TobInfoboxesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TobInfoboxesPlugin.class);
    @Inject
    private Client client;
    @Inject
    private TobInfoboxesConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;
    private static final Pattern MAIDEN_COMPLETE = Pattern.compile("Wave 'The Maiden of Sugadinti' \\((?:Story|Normal|Hard) Mode\\) complete!Duration: (\\d+):(\\d+)");
    private static final Pattern BLOAT_COMPLETE = Pattern.compile("Wave 'The Pestilent Bloat' \\((?:Story|Normal|Hard) Mode\\) complete!Duration: (\\d+):(\\d+)");
    private static final Pattern NYLOCAS_COMPLETE = Pattern.compile("Wave 'The Nylocas' \\((?:Story|Normal|Hard) Mode\\) complete!Duration: (\\d+):(\\d+)");
    private static final Pattern SOTETSEG_COMPLETE = Pattern.compile("Wave 'Sotetseg' \\((?:Story|Normal|Hard) Mode\\) complete!Duration: (\\d+):(\\d+)");
    private static final Pattern XARPUS_COMPLETE = Pattern.compile("Wave 'Xarpus' \\((?:Story|Normal|Hard) Mode\\) complete!Duration: (\\d+):(\\d+)");
    private static final Pattern VERZIK_COMPLETE = Pattern.compile("Wave 'The Final Challenge' \\((?:Story|Normal|Hard) Mode\\) complete!Duration: (\\d+):(\\d+)");
    private static final Pattern TOTAL_COMPLETE = Pattern.compile("Theatre of Blood wave completion time: (\\d+):(\\d+)");
    private TobInfobox maidenInfoBox;
    private TobInfobox bloatInfoBox;
    private TobInfobox nyloInfoBox;
    private TobInfobox soteInfoBox;
    private TobInfobox xarpusInfoBox;
    private TobInfobox verzikInfoBox;
    private TobInfobox totalInfoBox;
    boolean instanced = false;
    boolean prevInstance = false;

    protected void shutDown() throws Exception {
        this.removeAll();
    }

    private TobInfobox addInfoBox(String path, String bossname, int luminance, String time, boolean outline) {
        BufferedImage bossImg = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)path);
        if (outline) {
            bossImg = ImageUtil.outlineImage((BufferedImage)bossImg, (Color)Color.BLACK);
        }
        bossImg = ImageUtil.luminanceOffset((Image)bossImg, (int)luminance);
        TobInfobox box = new TobInfobox(bossImg, this, time, bossname);
        return box;
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Matcher mTotal;
        Matcher mVerzik;
        Matcher mXarp;
        Matcher mSote;
        Matcher mNylo;
        Matcher mBloat;
        String time;
        Matcher mMaiden;
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String message = Text.removeTags((String)event.getMessage());
        if (this.config.showMaiden() && (mMaiden = MAIDEN_COMPLETE.matcher(message)).find()) {
            time = mMaiden.group(1) + ":" + mMaiden.group(2);
            this.maidenInfoBox = this.addInfoBox("/maiden.png", "Maiden", -35, time, false);
            this.infoBoxManager.addInfoBox((InfoBox)this.maidenInfoBox);
        }
        if (this.config.showBloat() && (mBloat = BLOAT_COMPLETE.matcher(message)).find()) {
            time = mBloat.group(1) + ":" + mBloat.group(2);
            this.bloatInfoBox = this.addInfoBox("/bloat.png", "Bloat", -25, time, false);
            this.infoBoxManager.addInfoBox((InfoBox)this.bloatInfoBox);
        }
        if (this.config.showNylo() && (mNylo = NYLOCAS_COMPLETE.matcher(message)).find()) {
            time = mNylo.group(1) + ":" + mNylo.group(2);
            this.nyloInfoBox = this.addInfoBox("/nylo.png", "Nylo", -30, time, false);
            this.infoBoxManager.addInfoBox((InfoBox)this.nyloInfoBox);
        }
        if (this.config.showSotetseg() && (mSote = SOTETSEG_COMPLETE.matcher(message)).find()) {
            time = mSote.group(1) + ":" + mSote.group(2);
            this.soteInfoBox = this.addInfoBox("/sote.png", "Sotetseg", 0, time, false);
            this.infoBoxManager.addInfoBox((InfoBox)this.soteInfoBox);
        }
        if (this.config.showXarpus() && (mXarp = XARPUS_COMPLETE.matcher(message)).find()) {
            time = mXarp.group(1) + ":" + mXarp.group(2);
            this.xarpusInfoBox = this.addInfoBox("/xarp.png", "Xarpus", 0, time, true);
            this.infoBoxManager.addInfoBox((InfoBox)this.xarpusInfoBox);
        }
        if (this.config.showVerzik() && (mVerzik = VERZIK_COMPLETE.matcher(message)).find()) {
            time = mVerzik.group(1) + ":" + mVerzik.group(2);
            this.verzikInfoBox = this.addInfoBox("/verzik.png", "Verzik", 0, time, true);
            this.infoBoxManager.addInfoBox((InfoBox)this.verzikInfoBox);
        }
        if (this.config.showTotal() && (mTotal = TOTAL_COMPLETE.matcher(message)).find()) {
            time = mTotal.group(1) + ":" + mTotal.group(2);
            this.totalInfoBox = this.addInfoBox("/total.png", "Total", -35, time, false);
            this.infoBoxManager.addInfoBox((InfoBox)this.totalInfoBox);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!this.config.showMaiden()) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.maidenInfoBox);
        }
        if (!this.config.showBloat()) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.bloatInfoBox);
        }
        if (!this.config.showNylo()) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.nyloInfoBox);
        }
        if (!this.config.showSotetseg()) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.soteInfoBox);
        }
        if (!this.config.showXarpus()) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.xarpusInfoBox);
        }
        if (!this.config.showVerzik()) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.verzikInfoBox);
        }
        if (!this.config.showTotal()) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.totalInfoBox);
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.prevInstance = this.instanced;
        this.instanced = this.client.isInInstancedRegion();
        if (!this.prevInstance && this.instanced) {
            this.removeAll();
        }
    }

    private void removeAll() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.maidenInfoBox);
        this.infoBoxManager.removeInfoBox((InfoBox)this.bloatInfoBox);
        this.infoBoxManager.removeInfoBox((InfoBox)this.nyloInfoBox);
        this.infoBoxManager.removeInfoBox((InfoBox)this.soteInfoBox);
        this.infoBoxManager.removeInfoBox((InfoBox)this.xarpusInfoBox);
        this.infoBoxManager.removeInfoBox((InfoBox)this.verzikInfoBox);
        this.infoBoxManager.removeInfoBox((InfoBox)this.totalInfoBox);
    }

    @Provides
    TobInfoboxesConfig provideConfig(ConfigManager configManager) {
        return (TobInfoboxesConfig)configManager.getConfig(TobInfoboxesConfig.class);
    }
}

