/*
 * Decompiled with CFR 0.152.
 */
package com.zom.ignore;

import com.google.inject.Provides;
import com.zom.ignore.IgnoreListAlerterConfig;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Ignore List Alerter")
public class IgnoreListAlerterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(IgnoreListAlerterPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private IgnoreListAlerterConfig config;
    int delay = -1;
    HashMap<String, Instant> delayList;

    protected void startUp() throws Exception {
        this.delay = this.config.alertTimeOut();
        this.delayList = new HashMap();
    }

    protected void shutDown() throws Exception {
        this.delay = -1;
        this.delayList = null;
    }

    @Provides
    public IgnoreListAlerterConfig provideConfig(ConfigManager configManager) {
        return (IgnoreListAlerterConfig)configManager.getConfig(IgnoreListAlerterConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("zomignorelistalerter")) {
            this.delay = this.config.alertTimeOut();
        }
    }

    @Nullable
    private String getFriendNote(String displayName) {
        return this.configManager.getConfiguration("friendNotes", "note_" + displayName);
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned playerSpawned) {
        String note;
        Instant instant;
        String name = playerSpawned.getPlayer().getName();
        if (this.client.getIgnoreContainer().findByName(name) != null && (instant = this.delayList.getOrDefault(name, Instant.now().minus(1L, ChronoUnit.SECONDS))).isBefore(Instant.now()) && (note = this.getFriendNote(name)) != null) {
            this.delayList.put(name, Instant.now().plusSeconds((long)this.delay * 60L));
            this.alertPlayerWarning(name, note);
        }
    }

    private void alertPlayerWarning(String rsn, String note) {
        ChatMessageBuilder response = new ChatMessageBuilder();
        response.append("Nearby Player ").append(ChatColorType.HIGHLIGHT).append(rsn).append(ChatColorType.NORMAL).append(" is on ignore list for ").append(ChatColorType.HIGHLIGHT).append(note);
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(response.build()).build());
    }
}

