/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.varbits;

import com.Crowdsourcing.CrowdsourcingManager;
import com.Crowdsourcing.varbits.VarData;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Iterator;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.IndexDataBase;
import net.runelite.api.VarbitComposition;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdsourcingVarbits {
    private static final Logger log = LoggerFactory.getLogger(CrowdsourcingVarbits.class);
    @Inject
    private Client client;
    @Inject
    private CrowdsourcingManager crowdsourcingManager;
    @Inject
    private ClientThread clientThread;
    private static final int VARBITS_ARCHIVE_ID = 14;
    private int[] oldVarps = null;
    private int[] oldVarps2 = null;
    private Multimap<Integer, Integer> varbits;
    private int initializingTick = 0;
    private static HashSet<Integer> blackList;
    private static final int VARBIT = 0;
    private static final int VARPLAYER = 1;
    private boolean disconnected = false;

    public void startUp() {
        blackList = new HashSet();
        blackList.add(357);
        blackList.add(5983);
        blackList.add(8354);
        this.varbits = HashMultimap.create();
        if (this.client.getGameState() == GameState.STARTING || this.client.getGameState() == GameState.UNKNOWN) {
            return;
        }
        if (this.oldVarps == null) {
            this.oldVarps = new int[this.client.getVarps().length];
            this.oldVarps2 = new int[this.client.getVarps().length];
        }
        System.arraycopy(this.client.getVarps(), 0, this.oldVarps, 0, this.oldVarps.length);
        System.arraycopy(this.client.getVarps(), 0, this.oldVarps2, 0, this.oldVarps2.length);
        this.clientThread.invoke(() -> {
            int[] varbitIds;
            if (this.client.getIndexConfig() == null) {
                return false;
            }
            IndexDataBase indexVarbits = this.client.getIndexConfig();
            for (int id : varbitIds = indexVarbits.getFileIds(14)) {
                VarbitComposition varbit = this.client.getVarbit(id);
                if (varbit == null) continue;
                this.varbits.put((Object)varbit.getIndex(), (Object)id);
            }
            return true;
        });
    }

    public void shutDown() {
        this.varbits = null;
        this.oldVarps = null;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState().equals((Object)GameState.HOPPING) || gameStateChanged.getGameState().equals((Object)GameState.LOGGING_IN) || gameStateChanged.getGameState() == GameState.LOGGED_IN && this.disconnected) {
            this.disconnected = false;
            this.initializingTick = this.client.getTickCount() + 5;
            this.shutDown();
            this.startUp();
        }
        if (gameStateChanged.getGameState() == GameState.CONNECTION_LOST) {
            this.disconnected = true;
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        int tick = this.client.getTickCount();
        int index = varbitChanged.getIndex();
        int[] varps = this.client.getVarps();
        Iterator iterator = this.varbits.get((Object)index).iterator();
        while (iterator.hasNext()) {
            int newValue;
            int i = (Integer)iterator.next();
            int oldValue = this.client.getVarbitValue(this.oldVarps, i);
            if (oldValue == (newValue = this.client.getVarbitValue(varps, i)) || tick <= this.initializingTick) continue;
            this.client.setVarbitValue(this.oldVarps2, i, newValue);
            if (blackList.contains(i)) continue;
            this.clientThread.invokeLater(() -> {
                LocalPoint local = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.client.getLocalPlayer().getWorldLocation());
                WorldPoint location = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local);
                boolean isInInstance = this.client.isInInstancedRegion();
                VarData varbitData = new VarData(0, i, oldValue, newValue, tick, isInInstance, location);
                this.crowdsourcingManager.storeEvent(varbitData);
            });
        }
        int oldValue = this.oldVarps2[index];
        int newValue = varps[index];
        if (oldValue != newValue && tick > this.initializingTick) {
            this.clientThread.invokeLater(() -> {
                LocalPoint local = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.client.getLocalPlayer().getWorldLocation());
                WorldPoint location = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local);
                boolean isInInstance = this.client.isInInstancedRegion();
                VarData varPlayerData = new VarData(1, index, oldValue, newValue, tick, isInInstance, location);
                this.crowdsourcingManager.storeEvent(varPlayerData);
            });
        }
        this.oldVarps[index] = varps[index];
        this.oldVarps2[index] = varps[index];
    }
}

