/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.toa;

import com.Crowdsourcing.CrowdsourcingManager;
import com.Crowdsourcing.toa.TombsChatMessageData;
import com.Crowdsourcing.toa.TombsSkillChangedData;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.StatChanged;
import net.runelite.client.eventbus.Subscribe;

public class CrowdsourcingTombs {
    private static final String CHAT_MESSAGE_SMELLING_SALTS_START = "You crush the salts. Your heart rate increases.";
    private static final String CHAT_MESSAGE_NECTAR = "You drink some of the nectar. It hurts! This was not made for mortals.";
    private static final String CHAT_MESSAGE_TEARS = "You drink some of the tears.";
    private static final String CHAT_MESSAGE_TEARS_AOE = " has restored your prayer and combat stats.";
    private static final String CHAT_MESSAGE_AMBROSIA = "You drink the ambrosia. You feel reinvigorated.";
    private static final String CHAT_MESSAGE_HONEY_LOCUST = "You bite down on the dried bug. It's very chewy, but you feel slightly reinvigorated...";
    @Inject
    private CrowdsourcingManager manager;
    @Inject
    private Client client;
    private int currentTick = -1;
    private final ImmutableSet<Skill> skillsToCheck = ImmutableSet.builder().add((Object[])new Skill[]{Skill.HITPOINTS, Skill.ATTACK, Skill.STRENGTH, Skill.DEFENCE, Skill.RANGED, Skill.MAGIC, Skill.PRAYER, Skill.RANGED}).build();
    private final HashMap<Skill, Integer> prevCombatSkills = new HashMap();

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        boolean playerUsedItemOnSelf;
        String message = chatMessage.getMessage();
        boolean teammateUsedTears = message.contains(CHAT_MESSAGE_TEARS_AOE);
        boolean bl = playerUsedItemOnSelf = message.equals(CHAT_MESSAGE_TEARS) || message.equals(CHAT_MESSAGE_NECTAR) || message.equals(CHAT_MESSAGE_AMBROSIA) || message.equals(CHAT_MESSAGE_HONEY_LOCUST) || message.equals(CHAT_MESSAGE_SMELLING_SALTS_START);
        if (teammateUsedTears || playerUsedItemOnSelf) {
            for (Skill s : this.skillsToCheck) {
                this.prevCombatSkills.put(s, this.client.getBoostedSkillLevel(s));
            }
            this.currentTick = this.client.getTickCount();
            TombsChatMessageData data = new TombsChatMessageData(this.currentTick, message);
            this.manager.storeEvent(data);
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        Skill skill = statChanged.getSkill();
        if (this.currentTick == this.client.getTickCount() && this.skillsToCheck.contains((Object)skill)) {
            if (this.client.getBoostedSkillLevel(skill) == this.prevCombatSkills.get(skill).intValue()) {
                return;
            }
            TombsSkillChangedData data = new TombsSkillChangedData(this.currentTick, skill, this.client.getRealSkillLevel(skill), this.prevCombatSkills.get(skill), this.client.getBoostedSkillLevel(skill));
            this.manager.storeEvent(data);
        }
    }
}

