/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.shootingstars;

import com.Crowdsourcing.shootingstars.CannonData;
import com.Crowdsourcing.shootingstars.Locations;
import com.Crowdsourcing.shootingstars.Star;
import com.Crowdsourcing.shootingstars.StarData;
import com.Crowdsourcing.shootingstars.TelescopeData;
import com.Crowdsourcing.shootingstars.Tiers;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Ints;
import com.google.gson.Gson;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.RuneScapeProfileType;
import net.runelite.client.eventbus.Subscribe;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdsourcingStars {
    private static final Logger log = LoggerFactory.getLogger(CrowdsourcingStars.class);
    private static final int CANNON_VARBIT = 2180;
    private static final int VARBIT_THROTTLE_SECONDS = 5;
    private static final String CROWDSOURCING_URL = "https://crowdsource.runescape.wiki/shooting_stars";
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final Pattern STAR_PROGRESS = Pattern.compile("This is a size-(?<tier>[0-9]+) star.* It has been mined (?<progress>[0-9]+)%.*", 2);
    private static final int CHECK_SECONDS = 60000;
    private static final double HP_SUBMIT_CHANCE = 0.01;
    private static final double NEXT_TIER_SUBMIT_CHANCE = 0.01;
    private static final double MISSING_STAR_SUBMIT_CHANCE = 0.01;
    @Inject
    private Client client;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private Gson gson;
    private Star trackedStar;
    private StarData lastSent;
    private Map<Point, Long> checkedPoints = new HashMap<Point, Long>();
    private long cannonThrottle = -1L;

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getVarbitId() != 2180) {
            return;
        }
        int value = event.getValue();
        if (value == 0) {
            return;
        }
        long now = Instant.now().getEpochSecond();
        if (now - this.cannonThrottle >= 5L) {
            this.cannonThrottle = now;
            this.submitObject(new CannonData(value, now, this.client.getWorld(), RuneScapeProfileType.getCurrent((Client)this.client)));
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (event.getNpc().getId() != 10629) {
            return;
        }
        NPC npc = event.getNpc();
        if (this.trackedStar == null) {
            this.trackedStar = new Star(this.client.getWorld(), npc.getWorldLocation());
            this.checkedPoints.clear();
        }
        this.trackedStar.setNpc(npc);
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        if (event.getNpc().getId() != 10629) {
            return;
        }
        if (this.trackedStar == null) {
            return;
        }
        this.trackedStar.setNpc(null);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.checkStarProgress();
        this.checkMissingStar();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            this.reset();
        }
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.cannonThrottle = Instant.now().getEpochSecond();
        }
        if (event.getGameState() == GameState.LOADING) {
            this.checkedPoints.clear();
            if (this.trackedStar != null) {
                this.trackedStar.setGameObject(null);
            }
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        int tier = Tiers.of(gameObject.getId());
        if (tier < 0) {
            return;
        }
        if (this.trackedStar == null) {
            this.trackedStar = new Star(this.client.getWorld(), gameObject.getWorldLocation());
            this.checkedPoints.clear();
        }
        this.trackedStar.setGameObject(gameObject);
        if (this.trackedStar.getTier() == tier) {
            return;
        }
        int lastTier = this.trackedStar.getTier();
        if (lastTier > -1) {
            this.trackedStar.setHp(50);
        }
        this.trackedStar.setTier(tier);
        if (lastTier == -1 || this.shouldSubmit(0.01)) {
            this.submit();
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        int tier = Tiers.of(event.getGameObject().getId());
        if (tier < 0) {
            return;
        }
        if (this.trackedStar != null) {
            this.trackedStar.setGameObject(null);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.MESBOX) {
            return;
        }
        String message = event.getMessage();
        if (message.startsWith("You see a shooting star!") || message.equals("You look through the telescope but you don't see anything interesting.")) {
            this.submitTelescopeMessage(message);
            return;
        }
        Matcher m = STAR_PROGRESS.matcher(message);
        if (!m.matches()) {
            return;
        }
        if (this.trackedStar == null) {
            log.error("Tracked star not found");
            return;
        }
        int tier = (Integer)MoreObjects.firstNonNull((Object)Ints.tryParse((String)m.group("tier")), (Object)-1);
        int hp = (Integer)MoreObjects.firstNonNull((Object)Ints.tryParse((String)m.group("progress")), (Object)-1);
        this.trackedStar.setTier(tier);
        this.trackedStar.setHp((100 - hp) / 2);
        this.submitObject(StarData.builder().tier(tier).hp(hp).exact(true).world(this.client.getWorld()).location(this.trackedStar.getLocation()).mode(RuneScapeProfileType.getCurrent((Client)this.client)).build());
    }

    private void submitTelescopeMessage(String message) {
        String json = this.gson.toJson((Object)new TelescopeData(this.client.getWorld(), message, RuneScapeProfileType.getCurrent((Client)this.client)));
        log.debug("submitting {}", (Object)json);
        Request r = new Request.Builder().url(CROWDSOURCING_URL).post(RequestBody.create((MediaType)JSON, (String)json)).build();
        this.okHttpClient.newCall(r).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Error sending crowdsourcing data", (Throwable)e);
            }

            public void onResponse(Call call, Response response) {
                log.debug("Successfully sent crowdsourcing data");
                response.close();
            }
        });
    }

    private boolean shouldSubmit(double chance) {
        double n = Math.random();
        return n >= 1.0 - chance;
    }

    private void submit() {
        if (this.trackedStar == null) {
            log.error("Missing star to submit");
            return;
        }
        if (this.lastSent != null && this.lastSent.getTier() == this.trackedStar.getTier() && this.lastSent.getHp() != null && this.lastSent.getHp().intValue() == this.trackedStar.getHp() && this.lastSent.getWorld() == this.trackedStar.getWorld() && this.lastSent.getLocation().equals((Object)this.trackedStar.getLocation())) {
            log.debug("Not submitting, same information");
            return;
        }
        this.lastSent = StarData.builder().tier(this.trackedStar.getTier()).world(this.client.getWorld()).location(this.trackedStar.getLocation()).hp(this.trackedStar.getHp() > -1 ? Integer.valueOf(this.trackedStar.getHp()) : null).mode(RuneScapeProfileType.getCurrent((Client)this.client)).build();
        this.submitObject(this.lastSent);
    }

    private void submitObject(Object obj) {
        String json = this.gson.toJson(obj);
        log.debug("submitting {}", (Object)json);
        Request r = new Request.Builder().url(CROWDSOURCING_URL).post(RequestBody.create((MediaType)JSON, (String)json)).build();
        this.okHttpClient.newCall(r).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Error sending crowdsourcing data", (Throwable)e);
            }

            public void onResponse(Call call, Response response) {
                log.debug("Successfully sent crowdsourcing data");
                response.close();
            }
        });
    }

    private void checkStarProgress() {
        if (this.trackedStar == null) {
            return;
        }
        if (this.trackedStar.getNpc() == null) {
            if (this.trackedStar.getGameObject() == null) {
                this.reset();
            }
            return;
        }
        NPC npc = this.trackedStar.getNpc();
        int hp = npc.getHealthRatio();
        if (hp == -1 || hp == this.trackedStar.getHp()) {
            return;
        }
        int lastKnownHp = this.trackedStar.getHp();
        this.trackedStar.setHp(hp);
        if (lastKnownHp == -1 || this.shouldSubmit(0.01)) {
            this.submit();
        }
    }

    private void checkMissingStar() {
        if (this.trackedStar != null || this.client.getPlane() != 0) {
            return;
        }
        long now = System.currentTimeMillis();
        WorldPoint currentLocation = this.client.getLocalPlayer().getWorldLocation();
        for (int regionId : this.client.getMapRegions()) {
            if (!Locations.containsKey(regionId)) continue;
            for (Point p : Locations.get(regionId)) {
                long time;
                if (!WorldPoint.isInScene((Client)this.client, (int)p.getX(), (int)p.getY()) || Math.abs(currentLocation.getX() / 8 - p.getX() / 8) > 3 || Math.abs(currentLocation.getY() / 8 - p.getY() / 8) > 3 || now - (time = this.checkedPoints.getOrDefault(p, -1L).longValue()) < 60000L) continue;
                this.checkedPoints.put(p, now);
                if (time != -1L && !this.shouldSubmit(0.01)) continue;
                this.submitObject(StarData.builder().tier(0).world(this.client.getWorld()).location(new WorldPoint(p.getX(), p.getY(), this.client.getPlane())).mode(RuneScapeProfileType.getCurrent((Client)this.client)).build());
            }
        }
    }

    public void reset() {
        this.lastSent = null;
        this.trackedStar = null;
        this.checkedPoints.clear();
        this.cannonThrottle = -1L;
    }
}

