/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.scenery;

import com.Crowdsourcing.CrowdsourcingManager;
import com.Crowdsourcing.scenery.SceneryEvent;
import com.Crowdsourcing.scenery.SceneryEventType;
import com.google.common.collect.ImmutableSet;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdsourcingScenery {
    private static final Logger log = LoggerFactory.getLogger(CrowdsourcingScenery.class);
    @Inject
    private CrowdsourcingManager manager;
    @Inject
    private Client client;
    private GameState gameState;
    private static final int BLACKLIST_OVERRIDE_RATE = 100;
    private final ImmutableSet<Integer> blacklist = ImmutableSet.of((Object)40963, (Object)5121, (Object)37469, (Object)34833, (Object)5126, (Object)5127, (Object[])new Integer[]{29189, 13320, 5129, 13322, 41024, 41025, 41026, 13323, 41028, 41030, 41031, 41032, 5132, 41034, 41035, 5133, 5134, 5135, 13328, 13329, 13671, 41068, 13330, 13331, 18793, 5140, 13674, 15381, 13326, 5142, 5143, 5144, 41106, 13337, 13338, 15387, 5148, 41131, 41132, 41133, 41134, 15389, 41136, 41137, 41138, 41139, 41140, 5150, 41142, 41143, 41144, 41145, 41146, 28859, 41148, 41149, 41150, 41151, 41152, 5152, 41154, 41155, 41157, 13345, 41162, 5154, 26830, 37581, 26832, 26833, 26834, 26835, 26836, 26837, 26838, 41175, 26840, 15396, 26842, 41179, 26844, 41181, 26846, 13349, 26848, 26849, 26850, 26851, 26852, 26853, 26854, 26855, 26856, 26857, 26859, 26860, 37586, 26863, 26864, 26865, 26866, 26867, 26868, 26869, 26871, 26872, 37468, 13375, 13017, 33357, 5130, 13361, 18766, 18768, 18769, 18770, 18771, 18772, 18774, 18776, 18778, 18780, 18782, 18784, 18786, 18788, 18790, 18792, 13372, 18794, 18796, 18798, 13373, 18800, 18802, 18803, 18804, 18806, 18808, 18809, 18810, 18811, 18812, 18813, 18814, 18815, 13378, 41027, 5128, 33179, 33180, 33181, 15429, 4515, 4516, 4517, 4518, 4519, 4520, 4521, 4523, 4524, 4525, 4527, 4528, 4529, 4532, 4534, 41033, 4537, 27068, 27069, 27070, 29119, 29120, 29121, 29122, 29123, 29124, 29125, 29126, 29127, 29128, 29129, 29130, 29131, 29132, 29133, 13389, 29136, 29137, 29138, 29139, 29140, 29141, 29142, 29143, 29144, 29145, 29146, 29147, 29148, 29150, 29151, 29152, 13392, 29155, 29156, 37349, 29158, 29159, 29160, 29161, 29162, 13394, 29166, 37629, 29168, 29169, 13396, 13383, 13397, 29184, 29185, 13398, 13400, 26845, 29207, 29211, 13402, 5137, 33434, 29226, 29227, 29228, 29229, 29230, 29231, 29232, 29233, 29234, 29235, 29236, 29238, 29239, 29240, 29241, 29242, 29243, 37436, 37437, 29246, 29247, 10816, 41141, 33346, 33347, 29252, 33349, 33350, 33351, 33352, 33353, 29258, 29259, 29260, 29261, 6734, 6735, 29264, 37459, 29267, 29268, 29269, 29270, 29271, 29272, 6745, 6746, 6747, 29276, 29277, 19038, 6751, 6752, 6753, 6754, 6755, 6756, 6758, 6759, 6760, 6761, 6762, 6763, 6764, 6765, 6766, 6767, 6768, 6769, 6770, 33396, 13343, 13319, 6777, 6778, 6779, 6780, 6782, 33407, 5146, 33409, 6786, 6787, 6788, 6789, 6790, 40385, 6792, 6793, 6794, 33419, 33420, 27074, 6798, 6799, 6802, 6803, 6804, 6805, 6806, 29335, 33432, 29337, 29338, 2715, 29340, 29341, 29342, 29344, 29345, 29346, 29347, 29348, 29349, 29350, 29352, 29353, 29354, 29355, 29356, 29357, 29358, 29359, 29360, 29361, 37559, 27082, 5138, 27083, 37577, 37579, 13390, 13005, 37583, 37585, 13010, 37587, 37589, 37590, 37591, 37592, 37593, 13018, 37598, 33372, 37603, 13127, 37617, 37618, 37620, 37621, 33366, 37630, 6729, 13733, 41434, 13090, 13091, 13095, 13097, 13325, 13111, 13112, 13116, 13117, 13120, 13121, 31554, 13126, 29153, 13128, 13129, 13130, 13131, 13132, 13137, 13138, 13139, 13140, 13141, 13142, 13143, 13144, 13145, 13147, 13148, 13149, 13150, 29157, 13152, 13153, 13154, 13155, 13157, 13158, 13159, 13160, 13161, 13165, 13166, 13167, 13168, 13169, 13170, 13171, 13172, 13173, 13174, 13175, 13178, 13179, 13182, 13187, 13192, 13197, 26831, 40771, 5145, 15256, 15257, 15259, 15260, 13213, 15262, 15263, 13216, 15265, 15266, 15267, 15268, 15269, 15270, 15271, 15273, 15274, 15275, 15276, 15277, 15278, 15279, 15280, 15281, 15282, 15283, 15284, 15285, 15286, 15287, 15288, 15289, 15290, 15291, 15292, 15293, 15294, 15295, 15296, 15297, 15298, 15299, 15300, 15301, 15302, 15303, 15304, 31689, 15306, 39883, 39884, 15309, 15310, 13263, 5147, 15315, 15316, 15317, 13271, 13272, 6784, 15323, 15324, 15325, 15326, 15327, 15328, 15329, 13282, 15331, 13285, 15336, 15337, 13291, 13293, 15342, 15343, 15344, 15345, 15346, 15347, 15348, 15349, 15350, 15351, 15352, 15353, 15354, 15355, 15356, 13309, 13332, 13311, 13312, 15361, 15362, 15363, 15364, 15365, 15366, 15367, 15368, 15369, 15370, 15371, 15372, 15373, 15374, 15375, 15376, 15377, 15378, 15379, 15380, 5141, 15382, 15383, 15384, 15385, 15386, 13339, 13340, 5149, 13342, 5151, 15392, 15393, 15394, 15395, 13348, 15397, 15398, 15399, 15400, 15401, 15402, 15403, 15404, 15405, 15406, 15407, 15408, 15409, 13362, 13363, 13365, 13366, 13367, 13368, 13369, 13370, 13151, 15420, 15421, 15422, 15423, 15424, 15425, 15426, 15427, 13381, 13382, 15431, 15432, 13385, 15434, 15435, 15436, 15437, 15438, 15439, 15440, 15441, 15442, 15443, 15444, 15445, 15446, 15447, 15448, 15450, 13404, 41172, 41147, 33385, 26839, 41153, 9354, 9355, 5631, 13333, 4540, 5136, 13482, 13483, 13484, 13487, 13489, 13490, 13491, 13497, 13498, 13499, 13500, 13501, 13502, 13503, 13505, 13507, 13508, 13510, 13511, 13512, 13513, 13514, 13515, 13516, 13517, 13519, 13520, 13521, 13522, 13523, 13524, 13526, 13527, 13528, 13531, 6728, 13536, 13539, 13542, 31977, 31978, 13547, 13549, 13550, 13551, 31985, 13554, 13556, 13557, 13558, 13559, 13561, 13563, 13565, 13566, 13567, 13571, 13572, 13573, 13574, 13575, 13576, 13578, 13579, 13341, 26841, 26843, 6727, 15388, 13615, 13616, 13617, 13618, 13619, 13620, 41182, 13622, 13624, 13625, 13626, 13627, 13633, 13634, 13636, 13637, 13639, 13640, 13641, 13642, 13643, 13644, 13647, 13648, 13649, 13650, 13652, 13653, 13654, 13655, 13656, 13657, 13658, 13659, 13661, 13662, 13663, 13664, 13665, 13666, 13667, 13668, 13669, 13670, 13344, 13672, 13673, 15390, 13675, 13676, 13677, 26847, 29245, 13684, 13685, 13686, 13687, 13689, 13695, 13696, 29248, 29249, 15391, 37442, 26861, 13208, 29251, 13721, 13722, 13723, 13725, 29253, 40859, 13732, 29254, 13737, 29255, 31986, 15261, 29256, 13214, 13750, 29257, 13753, 13215, 40383, 40384, 15264, 13762, 33355, 13769, 6733, 13778, 13780, 29262, 29263, 13794, 13795, 13796, 13798, 13799, 13212, 13810, 6739, 13814, 13817, 6741, 5632, 13826, 13827, 6742, 13830, 13228, 6743, 13731, 6744, 29273, 29274, 29275, 6748, 33373, 6750, 33375, 13240, 13011, 5139, 26231, 41416, 33390, 33391, 29244, 6740, 15305, 26296, 26297, 26298, 26299, 15307, 15308, 6776, 33402, 13264, 33408, 33410, 5907, 33412, 33413, 33414, 6791, 13277, 33416, 33417, 33418, 40768, 40769, 40770, 6795, 40772, 40773, 40774, 13281, 40776, 40778, 40779, 15330, 13283, 29250, 34653, 34654, 13289, 33429, 6807, 40846, 40847, 40848, 29336, 40851, 13294, 33433, 13295, 40861, 40862, 40863, 4541, 29339, 40871, 40872, 13298, 40878, 40880, 13299, 27071, 6749, 13302, 40904, 13303, 13304, 40915, 27072, 40917, 13305, 13306, 13307, 13308, 41135, 33415, 31983, 13008, 13009, 13015, 13016, 13098, 13099, 13100, 13101, 13102, 13103, 13108, 13110, 13118, 13119, 13350, 13351, 13391, 13538, 13540, 13543, 13629, 13632, 13697, 13728, 13729, 13730, 15311, 15312, 15313, 15314, 15430, 15452, 18773, 18775, 18777, 18779, 18781, 18783, 18785, 18787, 18789, 18791, 18795, 18797, 18799, 18801, 18805, 18807, 26215, 26216, 26229, 26230, 26236, 26237, 26239, 26241, 26242, 26713, 27084, 27085, 27086, 27087, 29111, 29113, 29114, 29154, 29167, 29170, 29174, 29176, 29177, 29178, 29179, 29186, 29187, 29188, 29191, 29192, 29193, 29195, 29196, 29197, 29202, 29203, 29205, 29206, 29210, 29212, 29213, 29215, 29217, 29221, 29223, 30403, 31982, 32537, 37438, 37456, 37463, 37464, 37465, 37466, 37619, 39882, 40844, 40845, 41029, 41037, 41039, 41041, 41042, 41044, 41045, 41046, 41047, 41048, 41051, 41052, 41053, 41054, 41055, 41056, 41058, 41061, 41062, 41063, 41064, 41070, 41075, 41076, 41077, 41078, 41079, 41085, 41086, 41087, 41088, 41089, 41090, 41091, 41092, 41093, 41094, 41097, 41099, 41101, 41103, 41104, 41105, 41107, 41108, 41109, 41114, 41115, 41116, 41120, 41121, 41122, 41123, 41160, 41161, 41163, 41164, 41168, 41170, 41171, 41173, 41174, 41176, 41177, 41178, 6521, 36000, 36001, 35970, 35971, 35972, 35973, 35974, 35975, 35976, 35968, 35969, 36046, 36047, 36048, 35992, 35994, 35999, 35998, 35967, 36095, 36103, 36150, 36104, 36151, 36149, 26664, 26662, 26661, 26663, 10459, 2018, 25028, 25027, 25023, 25022, 25021, 25019, 25018, 25017, 25016, 25000, 40979, 40976, 40971, 40970, 40969, 40968, 33034, 33033, 41594, 4451, 26185});

    private void addObjectThisTick(SceneryEventType type, WorldPoint baseLocation, int id) {
        if (this.gameState != GameState.LOGGED_IN) {
            return;
        }
        int rate = 1;
        if (this.blacklist.contains((Object)id)) {
            if (Math.random() < 0.01) {
                rate = 100;
            } else {
                return;
            }
        }
        LocalPoint local = LocalPoint.fromWorld((Client)this.client, (WorldPoint)baseLocation);
        WorldPoint location = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local);
        this.manager.storeEvent(new SceneryEvent(type, location, id, rate));
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned event) {
        this.addObjectThisTick(SceneryEventType.DECORATIVE_OBJECT_SPAWNED, event.getTile().getWorldLocation(), event.getDecorativeObject().getId());
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned event) {
        this.addObjectThisTick(SceneryEventType.WALL_OBJECT_SPAWNED, event.getTile().getWorldLocation(), event.getWallObject().getId());
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.addObjectThisTick(SceneryEventType.GAME_OBJECT_SPAWNED, event.getTile().getWorldLocation(), event.getGameObject().getId());
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned event) {
        this.addObjectThisTick(SceneryEventType.GROUND_OBJECT_SPAWNED, event.getTile().getWorldLocation(), event.getGroundObject().getId());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.gameState = event.getGameState();
    }
}

