/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.respawns;

import com.Crowdsourcing.CrowdsourcingManager;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.ObjectComposition;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.DecorativeObjectDespawned;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Respawns", description="Logs scenery and item respawn times to your chatbox.")
public class Respawns {
    private static final Logger log = LoggerFactory.getLogger(Respawns.class);
    @Inject
    private Client client;
    @Inject
    private WorldService worldService;
    @Inject
    private CrowdsourcingManager manager;
    @Inject
    private ItemManager itemManager;
    private GameState gameState;
    private static final int MAX_DESPAWN_ENTRIES = 5000;
    private Map<RespawnKey, Integer> despawnedScenery = new LinkedHashMap<RespawnKey, Integer>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<RespawnKey, Integer> eldest) {
            return this.size() > 5000;
        }
    };
    private Map<RespawnKey, ItemRespawnValue> despawnedItems = new LinkedHashMap<RespawnKey, ItemRespawnValue>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<RespawnKey, ItemRespawnValue> eldest) {
            return this.size() > 5000;
        }
    };

    @Subscribe
    public void onItemSpawned(ItemSpawned event) {
        RespawnKey key = new RespawnKey(event.getTile().getWorldLocation(), event.getItem().getId());
        if (this.despawnedItems.containsKey(key)) {
            int diff = this.client.getTickCount() - this.despawnedItems.get(key).getTickCount();
            if (diff == 0) {
                return;
            }
            int worldPopulation = this.despawnedItems.get(key).getWorldPopulation();
            int estimate = diff * 4000 / (4000 - worldPopulation) + 1;
            this.despawnedItems.remove(key);
            String name = this.itemManager.getItemComposition(key.getId()).getName();
            String message = String.format("ITEM %s: %d ticks on %d population, estimate: %d", name, diff, worldPopulation, estimate + 1);
            this.manager.sendMessage(message);
        }
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned event) {
        int worldPopulation = this.worldService.getWorlds().findWorld(this.client.getWorld()).getPlayers();
        RespawnKey key = new RespawnKey(event.getTile().getWorldLocation(), event.getItem().getId());
        this.despawnedItems.put(key, new ItemRespawnValue(this.client.getTickCount(), worldPopulation));
    }

    private void scenerySpawn(WorldPoint baseLocation, int id) {
        if (this.gameState != GameState.LOGGED_IN) {
            return;
        }
        RespawnKey key = new RespawnKey(baseLocation, id);
        if (this.despawnedScenery.containsKey(key)) {
            int diff = this.client.getTickCount() - this.despawnedScenery.get(key);
            this.despawnedScenery.remove(key);
            ObjectComposition objectComposition = this.client.getObjectDefinition(id);
            objectComposition = objectComposition.getImpostorIds() == null ? objectComposition : objectComposition.getImpostor();
            String name = objectComposition.getName();
            String message = String.format("SCENERY %s (id: %d): %d ticks", name, id, diff + 1);
            this.manager.sendMessage(message);
        }
    }

    private void sceneryDespawn(WorldPoint baseLocation, int id) {
        if (this.gameState != GameState.LOGGED_IN) {
            return;
        }
        RespawnKey key = new RespawnKey(baseLocation, id);
        this.despawnedScenery.put(key, this.client.getTickCount());
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned event) {
        this.scenerySpawn(event.getTile().getWorldLocation(), event.getDecorativeObject().getId());
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned event) {
        this.scenerySpawn(event.getTile().getWorldLocation(), event.getWallObject().getId());
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.scenerySpawn(event.getTile().getWorldLocation(), event.getGameObject().getId());
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned event) {
        this.scenerySpawn(event.getTile().getWorldLocation(), event.getGroundObject().getId());
    }

    @Subscribe
    public void onDecorativeObjectDespawned(DecorativeObjectDespawned event) {
        this.sceneryDespawn(event.getTile().getWorldLocation(), event.getDecorativeObject().getId());
    }

    @Subscribe
    public void onWallObjectDespawned(WallObjectDespawned event) {
        this.sceneryDespawn(event.getTile().getWorldLocation(), event.getWallObject().getId());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        this.sceneryDespawn(event.getTile().getWorldLocation(), event.getGameObject().getId());
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned event) {
        this.sceneryDespawn(event.getTile().getWorldLocation(), event.getGroundObject().getId());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.gameState = event.getGameState();
        if (this.gameState == GameState.LOGIN_SCREEN || this.gameState == GameState.HOPPING) {
            this.despawnedScenery.clear();
            this.despawnedItems.clear();
        }
    }

    static class ItemRespawnValue {
        private final int tickCount;
        private final int worldPopulation;

        public int getTickCount() {
            return this.tickCount;
        }

        public int getWorldPopulation() {
            return this.worldPopulation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemRespawnValue)) {
                return false;
            }
            ItemRespawnValue other = (ItemRespawnValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTickCount() != other.getTickCount()) {
                return false;
            }
            return this.getWorldPopulation() == other.getWorldPopulation();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ItemRespawnValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTickCount();
            result = result * 59 + this.getWorldPopulation();
            return result;
        }

        public String toString() {
            return "Respawns.ItemRespawnValue(tickCount=" + this.getTickCount() + ", worldPopulation=" + this.getWorldPopulation() + ")";
        }

        public ItemRespawnValue(int tickCount, int worldPopulation) {
            this.tickCount = tickCount;
            this.worldPopulation = worldPopulation;
        }
    }

    static class RespawnKey {
        private final WorldPoint location;
        private final int id;

        public WorldPoint getLocation() {
            return this.location;
        }

        public int getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RespawnKey)) {
                return false;
            }
            RespawnKey other = (RespawnKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            WorldPoint this$location = this.getLocation();
            WorldPoint other$location = other.getLocation();
            return !(this$location == null ? other$location != null : !this$location.equals(other$location));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RespawnKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            WorldPoint $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : $location.hashCode());
            return result;
        }

        public String toString() {
            return "Respawns.RespawnKey(location=" + this.getLocation() + ", id=" + this.getId() + ")";
        }

        public RespawnKey(WorldPoint location, int id) {
            this.location = location;
            this.id = id;
        }
    }
}

