/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.pyramid_plunder;

import com.Crowdsourcing.CrowdsourcingManager;
import com.Crowdsourcing.pyramid_plunder.PyramidPlunderMessageData;
import com.Crowdsourcing.pyramid_plunder.PyramidPlunderSceneryData;
import com.Crowdsourcing.pyramid_plunder.PyramidPlunderVarbData;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdsourcingPyramidPlunder {
    private static final Logger log = LoggerFactory.getLogger(CrowdsourcingPyramidPlunder.class);
    @Inject
    public CrowdsourcingManager manager;
    @Inject
    public Client client;
    private final WorldArea inside = new WorldArea(1916, 4418, 70, 62, 0);
    private final WorldArea insideFloor1 = new WorldArea(1916, 4418, 70, 62, 1);
    private final WorldArea insideFloor2 = new WorldArea(1916, 4418, 70, 62, 2);
    private final WorldArea outside = new WorldArea(3281, 2787, 16, 17, 0);
    ImmutableSet<Integer> varbsToTrack = ImmutableSet.builder().add((Object)2346).add((Object)2347).add((Object)2348).add((Object)2349).add((Object)2350).add((Object)2351).add((Object)2352).add((Object)2353).add((Object)2354).add((Object)2355).add((Object)2356).add((Object)2357).add((Object)2358).add((Object)2359).add((Object)2362).add((Object)2363).build();
    HashMap<Integer, Integer> varbVals = new HashMap();
    ImmutableSet<Integer> objectIdsToCheck = ImmutableSet.builder().add((Object)20956).add((Object)20974).add((Object)20975).add((Object)20976).add((Object)20977).add((Object)20978).add((Object)20979).add((Object)20987).add((Object)21251).add((Object)21252).add((Object)21253).add((Object)21254).add((Object)21280).add((Object)20946).add((Object)20947).add((Object)21255).add((Object)21256).add((Object)21257).add((Object)21261).add((Object)21262).add((Object)21263).add((Object)21264).add((Object)21265).add((Object)21266).add((Object)21267).add((Object)21268).add((Object)21269).add((Object)21270).add((Object)21271).add((Object)21272).add((Object)21273).add((Object)21274).add((Object)21275).add((Object)21276).add((Object)21277).add((Object)21278).add((Object)21279).add((Object)20948).add((Object)20949).add((Object)20931).add((Object)20932).build();

    public void startUp() {
        if (this.client == null) {
            return;
        }
        for (Integer varbIndex : this.varbsToTrack) {
            if (varbIndex == null) continue;
            this.varbVals.put(varbIndex, 0);
        }
    }

    private boolean isInPyramidPlunder(WorldPoint w) {
        return w.isInArea(new WorldArea[]{this.inside}) || w.isInArea(new WorldArea[]{this.insideFloor1}) || w.isInArea(new WorldArea[]{this.insideFloor2}) || w.isInArea(new WorldArea[]{this.outside});
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        if (this.client == null) {
            return;
        }
        for (Integer varbIndex : this.varbsToTrack) {
            int oldVarbVal = this.varbVals.get(varbIndex);
            int newVarbVal = this.client.getVarbitValue(varbIndex.intValue());
            if (newVarbVal == oldVarbVal) continue;
            this.varbVals.put(varbIndex, this.client.getVarbitValue(varbIndex.intValue()));
            WorldPoint w = this.client.getLocalPlayer().getWorldLocation();
            int unboostedLevel = this.client.getRealSkillLevel(Skill.THIEVING);
            int boostedLevel = this.client.getBoostedSkillLevel(Skill.THIEVING);
            if (!this.isInPyramidPlunder(w)) continue;
            PyramidPlunderVarbData data = new PyramidPlunderVarbData(varbIndex, oldVarbVal, newVarbVal, w, unboostedLevel, boostedLevel, this.client.getTickCount());
            this.manager.storeEvent(data);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.GAMEMESSAGE && chatMessage.getType() != ChatMessageType.SPAM) {
            return;
        }
        String message = chatMessage.getMessage();
        if (this.client == null || this.client.getLocalPlayer() == null) {
            return;
        }
        int unboostedLevel = this.client.getRealSkillLevel(Skill.THIEVING);
        int boostedLevel = this.client.getBoostedSkillLevel(Skill.THIEVING);
        WorldPoint w = this.client.getLocalPlayer().getWorldLocation();
        if (this.isInPyramidPlunder(w)) {
            PyramidPlunderMessageData data = new PyramidPlunderMessageData(message, w, unboostedLevel, boostedLevel, this.client.getTickCount());
            this.manager.storeEvent(data);
        }
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        int tick = this.client.getTickCount();
        if (event.getMenuAction() == MenuAction.GAME_OBJECT_FIRST_OPTION || event.getMenuAction() == MenuAction.GAME_OBJECT_SECOND_OPTION) {
            ObjectComposition objectComposition = this.client.getObjectDefinition(event.getId());
            int id = objectComposition.getImpostorIds() == null ? objectComposition.getId() : objectComposition.getImpostor().getId();
            if (this.objectIdsToCheck.contains((Object)id)) {
                int unboostedLevel = this.client.getRealSkillLevel(Skill.THIEVING);
                int boostedLevel = this.client.getBoostedSkillLevel(Skill.THIEVING);
                WorldPoint w = WorldPoint.fromScene((Client)this.client, (int)event.getParam0(), (int)event.getParam1(), (int)this.client.getPlane());
                PyramidPlunderSceneryData data = new PyramidPlunderSceneryData(id, objectComposition.getId(), event.getMenuAction().getId(), w, unboostedLevel, boostedLevel, tick);
                this.manager.storeEvent(data);
            }
        } else if (event.getMenuAction() == MenuAction.NPC_THIRD_OPTION && event.getMenuTarget().equals("<col=ffff00>Guardian mummy")) {
            int unboostedLevel = this.client.getRealSkillLevel(Skill.THIEVING);
            int boostedLevel = this.client.getBoostedSkillLevel(Skill.THIEVING);
            WorldPoint w = WorldPoint.fromScene((Client)this.client, (int)event.getParam0(), (int)event.getParam1(), (int)this.client.getPlane());
            PyramidPlunderSceneryData data = new PyramidPlunderSceneryData(1779, 1779, event.getMenuAction().getId(), w, unboostedLevel, boostedLevel, tick);
            this.manager.storeEvent(data);
        }
    }
}

