/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.pottery;

import com.Crowdsourcing.CrowdsourcingManager;
import com.Crowdsourcing.pottery.PotteryData;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.eventbus.Subscribe;

public class CrowdsourcingPottery {
    private static final String FIRING_SUCCESS_PREFIX = "You remove the ";
    private static final String FIRING_SUCCESS_SUFFIX = " from the oven.";
    private static final String FIRING_FAILURE_PREFIX = "The ";
    private static final String FIRING_FAILURE_SUFFIX = " cracks in the oven.";
    @Inject
    private CrowdsourcingManager manager;
    @Inject
    private Client client;

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (!ChatMessageType.SPAM.equals((Object)event.getType())) {
            return;
        }
        String message = event.getMessage();
        if (message.startsWith(FIRING_SUCCESS_PREFIX) && message.endsWith(FIRING_SUCCESS_SUFFIX) || message.startsWith(FIRING_FAILURE_PREFIX) && message.endsWith(FIRING_FAILURE_SUFFIX)) {
            int craftingLevel = this.client.getBoostedSkillLevel(Skill.CRAFTING);
            PotteryData data = new PotteryData(message, craftingLevel);
            this.manager.storeEvent(data);
        }
    }
}

