/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.playerkit;

import com.Crowdsourcing.CrowdsourcingManager;
import com.Crowdsourcing.playerkit.PlayerkitData;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdsourcingPlayerkit {
    private static final Logger log = LoggerFactory.getLogger(CrowdsourcingPlayerkit.class);
    @Inject
    private CrowdsourcingManager manager;
    @Inject
    private Client client;
    private GameState gameState;

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (itemContainerChanged.getItemContainer() != this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            return;
        }
        try {
            int[] playerkit = this.client.getLocalPlayer().getPlayerComposition().getEquipmentIds();
            int poseAnim = this.client.getLocalPlayer().getIdlePoseAnimation();
            PlayerkitData playerkitData = new PlayerkitData(playerkit, poseAnim);
            this.manager.storeEvent(playerkitData);
            log.debug("playerkit: " + Arrays.toString(playerkit));
            log.debug("idle_pose_anim: " + poseAnim);
        }
        catch (NullPointerException e) {
            log.warn(e.toString());
        }
    }
}

