/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.overhead_dialogue;

import com.Crowdsourcing.CrowdsourcingManager;
import com.Crowdsourcing.overhead_dialogue.OverheadDialogueData;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdsourcingOverheadDialogue {
    private static final Logger log = LoggerFactory.getLogger(CrowdsourcingOverheadDialogue.class);
    @Inject
    public CrowdsourcingManager manager;
    @Inject
    public Client client;
    public static CacheLoader<Tuple, Boolean> loader = new CacheLoader<Tuple, Boolean>(){

        public Boolean load(Tuple key) {
            return true;
        }
    };
    public static LoadingCache<Tuple, Boolean> recentlySeen = CacheBuilder.newBuilder().maximumSize(100L).build(loader);

    @Subscribe
    public void onOverheadTextChanged(OverheadTextChanged event) {
        if (!(event.getActor() instanceof NPC)) {
            return;
        }
        NPC npc = (NPC)event.getActor();
        Tuple npcPair = new Tuple(npc.getComposition().getId(), event.getOverheadText());
        if (recentlySeen.getIfPresent((Object)npcPair) != null) {
            log.debug("Already saw this pair in the last 100 sightings");
            return;
        }
        OverheadDialogueData data = new OverheadDialogueData(npc.getComposition().getId(), event.getOverheadText());
        this.manager.storeEvent(data);
        try {
            log.debug("Message recorded from NPC id: " + npc.getComposition().getId());
            recentlySeen.get((Object)npcPair);
        }
        catch (ExecutionException e) {
            log.debug("ExecutionException caught");
        }
    }

    static class Tuple {
        public final int npcId;
        public final String text;

        public Tuple(int npcId, String text) {
            this.npcId = npcId;
            this.text = text;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Tuple)) {
                return false;
            }
            Tuple t = (Tuple)o;
            return this.npcId == t.npcId && this.text.equals(t.text);
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 486187739 + this.npcId;
            hash = hash * 486187739 + this.text.hashCode();
            return hash;
        }
    }
}

