/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.npc_respawn;

import com.Crowdsourcing.CrowdsourcingManager;
import com.Crowdsourcing.npc_respawn.NpcRespawnData;
import java.util.HashMap;
import java.util.HashSet;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.eventbus.Subscribe;

public class CrowdsourcingNpcRespawn {
    private static final int MAX_ACTOR_VIEW_RANGE = 15;
    private WorldPoint lastPlayerLocation;
    private HashMap<Integer, Integer> npcDespawnTimes = new HashMap();
    private HashSet<Integer> seenNpcs = new HashSet();
    private boolean logging = false;
    @Inject
    private Client client;
    @Inject
    public CrowdsourcingManager manager;

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    private static boolean isInViewRange(WorldPoint wp1, WorldPoint wp2) {
        int distance = wp1.distanceTo(wp2);
        return distance < 15;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.lastPlayerLocation = this.client.getLocalPlayer().getWorldLocation();
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        int index = npc.getIndex();
        if (!this.npcDespawnTimes.containsKey(index)) {
            return;
        }
        if (this.lastPlayerLocation != null && CrowdsourcingNpcRespawn.isInViewRange(this.lastPlayerLocation, npc.getWorldLocation())) {
            int respawnTime = this.client.getTickCount() - this.npcDespawnTimes.get(index);
            LocalPoint local = LocalPoint.fromWorld((Client)this.client, (WorldPoint)npc.getWorldLocation());
            WorldPoint location = null;
            boolean isInInstance = false;
            if (local != null) {
                location = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local);
                isInInstance = this.client.isInInstancedRegion();
            }
            this.manager.storeEvent(new NpcRespawnData(index, npc.getId(), respawnTime, location, isInInstance));
            if (this.logging) {
                this.manager.sendMessage(String.format("NPC %d: %d ticks", npc.getId(), respawnTime + 1));
            }
            this.seenNpcs.add(index);
            this.npcDespawnTimes.remove(index);
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        int index = npc.getIndex();
        if (this.seenNpcs.contains(index)) {
            return;
        }
        if (CrowdsourcingNpcRespawn.isInViewRange(this.client.getLocalPlayer().getWorldLocation(), npc.getWorldLocation())) {
            this.npcDespawnTimes.put(index, this.client.getTickCount());
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            this.npcDespawnTimes.clear();
        }
    }
}

