/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.monster_examine;

import com.Crowdsourcing.monster_examine.MonsterExamine;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

@Singleton
class MonsterExamineOverlay
extends Overlay {
    private final Client client;
    private final MonsterExamine plugin;
    private static final Color PURPLE = new Color(170, 0, 255);

    @Inject
    private MonsterExamineOverlay(Client client, MonsterExamine plugin) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.HIGHEST);
        this.client = client;
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        for (NPC npc : this.client.getNpcs()) {
            Shape objectClickbox;
            NPCComposition composition;
            if (npc == null || this.plugin.getSeenIds().contains(npc.getComposition().getId()) || !Arrays.asList((composition = npc.getComposition()).getActions()).contains("Attack") || (objectClickbox = npc.getConvexHull()) == null) continue;
            String text = "ID:" + composition.getId();
            Point textLocation = npc.getCanvasTextLocation(graphics, text, npc.getLogicalHeight() + 40);
            if (textLocation != null) {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)text, (Color)PURPLE);
            }
            graphics.setColor(PURPLE);
            graphics.draw(objectClickbox);
            graphics.setColor(new Color(PURPLE.getRed(), PURPLE.getGreen(), PURPLE.getBlue(), 20));
            graphics.fill(objectClickbox);
        }
        return null;
    }
}

