/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.monster_examine;

import com.Crowdsourcing.monster_examine.MonsterExamine;
import com.Crowdsourcing.monster_examine.MonsterExamineData;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonsterExamineClient {
    private static final Logger log = LoggerFactory.getLogger(MonsterExamineClient.class);
    private static final String SUBMIT_URL = "https://chisel.weirdgloop.org/monsterexamine/submit";
    private static final String SEEN_URL = "https://chisel.weirdgloop.org/monsterexamine/seen";
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final MonsterExamine plugin;

    @Inject
    private MonsterExamineClient(MonsterExamine plugin) {
        this.plugin = plugin;
    }

    protected void submitToAPI(MonsterExamineData data) {
        Request r = new Request.Builder().url(SUBMIT_URL).post(RequestBody.create((MediaType)JSON, (String)RuneLiteAPI.GSON.toJson((Object)data))).build();
        RuneLiteAPI.CLIENT.newCall(r).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Error sending monster examine data", (Throwable)e);
            }

            public void onResponse(Call call, Response response) {
                log.info("Successfully sent monster examine data");
                MonsterExamineClient.this.getSeenIds();
                response.close();
            }
        });
    }

    protected void getSeenIds() {
        Request request = new Request.Builder().url(SEEN_URL).build();
        RuneLiteAPI.CLIENT.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Error getting seen monster ids", (Throwable)e);
            }

            public void onResponse(Call call, Response response) {
                try {
                    InputStream in = response.body().byteStream();
                    Set tmp = (Set)RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), new TypeToken<Set<Integer>>(){}.getType());
                    if (tmp == null) {
                        log.debug("Error parsing monster ids JSON");
                        response.close();
                        return;
                    }
                    MonsterExamineClient.this.plugin.setSeenIds(tmp);
                    response.close();
                }
                catch (JsonParseException ex) {
                    log.debug("Error parsing monster ids JSON", (Throwable)ex);
                    response.close();
                }
            }
        });
    }
}

