/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.monster_examine;

import com.Crowdsourcing.monster_examine.MonsterExamineClient;
import com.Crowdsourcing.monster_examine.MonsterExamineData;
import com.Crowdsourcing.monster_examine.MonsterExamineOverlay;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonsterExamine {
    private static final Logger log = LoggerFactory.getLogger(MonsterExamine.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MonsterExamineOverlay overlay;
    @Inject
    private MonsterExamineClient httpClient;
    int lastId = -1;
    Set<Integer> seenIds = new HashSet<Integer>();

    public void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.httpClient.getSeenIds();
    }

    public void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        String target = event.getMenuTarget();
        if (target.startsWith("<col=00ff00>Monster Examine</col><col=ffffff> -> ")) {
            this.lastId = this.client.getCachedNPCs()[event.getId()].getComposition().getId();
        }
    }

    public void setSeenIds(Set<Integer> seenIds) {
        this.seenIds = seenIds;
    }

    public Set<Integer> getSeenIds() {
        return this.seenIds;
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 1179) {
            String name = this.client.getWidget(522, 3).getText();
            String stats = this.client.getWidget(522, 20).getText();
            String aggressive = this.client.getWidget(522, 22).getText();
            String defensive = this.client.getWidget(522, 24).getText();
            String other = this.client.getWidget(522, 26).getText();
            this.httpClient.submitToAPI(new MonsterExamineData(this.lastId, name, stats, aggressive, defensive, other, this.client.getLocalPlayer().getName()));
        }
    }
}

